/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.debug;

import io.cucumber.eclipse.editor.debug.GherkingDebugElement;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;

public class GherkingThread
extends GherkingDebugElement
implements IThread {
    private volatile SuspendContext context;

    GherkingThread(IDebugTarget target) {
        super(target);
    }

    public boolean canResume() {
        return this.context != null;
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean isSuspended() {
        return this.context != null;
    }

    public void resume() throws DebugException {
        this.context().ifPresent(c -> {
            this.context = null;
            c.latch.countDown();
            this.fireResumeEvent(32);
        });
    }

    private Optional<SuspendContext> context() {
        return Optional.ofNullable(this.context);
    }

    public void suspend() throws DebugException {
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean canStepOver() {
        return false;
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return false;
    }

    public void stepInto() throws DebugException {
    }

    public void stepOver() throws DebugException {
    }

    public void stepReturn() throws DebugException {
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        return this.context().map(c -> c.stackFrames).orElseGet(() -> new IStackFrame[0]);
    }

    public boolean hasStackFrames() throws DebugException {
        return this.context().filter(c -> c.stackFrames.length > 0).isPresent();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] frames = this.getStackFrames();
        if (frames.length > 0) {
            return frames[0];
        }
        return null;
    }

    public String getName() throws DebugException {
        return "Cucumber-Event-Thread";
    }

    public IBreakpoint[] getBreakpoints() {
        return this.context().map(SuspendContext::getBreakPoints).orElseGet(() -> new IBreakpoint[0]);
    }

    public synchronized CountDownLatch suspend(IBreakpoint breakpoint, IStackFrame[] stackFrames) {
        if (this.context != null) {
            throw new IllegalStateException();
        }
        this.context = new SuspendContext(breakpoint, stackFrames);
        this.fireSuspendEvent(16);
        return this.context.latch;
    }

    public CountDownLatch suspend(IStackFrame[] stackFrames, int detail) {
        if (this.context != null) {
            throw new IllegalStateException();
        }
        this.context = new SuspendContext(null, stackFrames);
        this.fireSuspendEvent(detail);
        return this.context.latch;
    }

    private static final class SuspendContext {
        private IBreakpoint breakpoint;
        private IStackFrame[] stackFrames;
        private CountDownLatch latch = new CountDownLatch(1);

        public SuspendContext(IBreakpoint breakpoint, IStackFrame[] stackFrames) {
            this.breakpoint = breakpoint;
            this.stackFrames = stackFrames;
        }

        public IBreakpoint[] getBreakPoints() {
            if (this.breakpoint == null) {
                return null;
            }
            return new IBreakpoint[]{this.breakpoint};
        }
    }
}

