/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.debug;

import io.cucumber.eclipse.editor.debug.GherkingBreakpoint;
import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.editor.document.GherkinEditorDocumentManager;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.Step;
import java.util.stream.Stream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.service.component.annotations.Component;

@Component(service={IToggleBreakpointsTarget.class})
public class GherkingToggleBreakpointsTarget
implements IToggleBreakpointsTargetExtension {
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleBreakpoints(part, selection);
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleBreakpoints(part, selection);
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        ITextEditor textEditor;
        GherkinEditorDocument gherkinEditorDocument;
        ITextViewer textViewer = (ITextViewer)Adapters.adapt((Object)part, ITextViewer.class);
        if (textViewer != null && (gherkinEditorDocument = GherkinEditorDocumentManager.get(textViewer.getDocument())) != null && (textEditor = (ITextEditor)Adapters.adapt((Object)part, ITextEditor.class)) != null) {
            IBreakpoint[] breakpoints;
            IResource resource = (IResource)textEditor.getEditorInput().getAdapter(IResource.class);
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine();
            IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(GherkingBreakpoint.MODEL_ID);
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                if (breakpoint instanceof ILineBreakpoint && resource.equals((Object)breakpoint.getMarker().getResource()) && ((ILineBreakpoint)breakpoint).getLineNumber() == lineNumber + 1) {
                    breakpoint.delete();
                    return;
                }
                ++n2;
            }
            GherkingBreakpoint lineBreakpoint = new GherkingBreakpoint(resource, lineNumber + 1);
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)lineBreakpoint);
        }
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        IDocument document;
        ITextViewer textViewer;
        if (selection instanceof ITextSelection && (textViewer = (ITextViewer)Adapters.adapt((Object)part, ITextViewer.class)) != null && (document = textViewer.getDocument()) != null) {
            GherkinEditorDocument editorDocument = GherkinEditorDocumentManager.get(document);
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine() + 1;
            Stream<Location> stream = editorDocument.getSteps().map(Step::getLocation);
            return stream.mapToLong(Location::getLine).filter(line -> line == (long)lineNumber).findAny().isPresent();
        }
        return false;
    }
}

