/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.document;

import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextStore;

class FileBasedDocument
extends Document {
    private IFile file;

    FileBasedDocument(IFile resource) {
        this.file = resource;
    }

    private FileBasedDocument(IFile file, String content) {
        super(content);
        this.file = file;
    }

    IResource getFile() {
        return this.file;
    }

    public synchronized String get() {
        return super.get();
    }

    public synchronized void set(String text) {
        super.set(text);
    }

    protected synchronized ITextStore getStore() {
        return super.getStore();
    }

    protected synchronized void setTextStore(ITextStore store) {
        super.setTextStore(store);
    }

    void reload() throws IOException, CoreException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream stream = this.file.getContents();){
            this.set(IOUtils.toString((InputStream)stream, (String)this.file.getCharset()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static GherkinEditorDocument loadFromFile(IFile file) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream stream = file.getContents();){
                FileBasedDocument document = new FileBasedDocument(file, IOUtils.toString((InputStream)stream, (String)file.getCharset()));
                return GherkinEditorDocument.create((IDocument)document, () -> file);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            return null;
        }
    }

    public String toString() {
        return "FileBasedDocument [" + String.valueOf(this.file) + "]";
    }
}

