/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.document;

import io.cucumber.eclipse.editor.document.GherkinKeyword;
import io.cucumber.eclipse.editor.document.GherkinStream;
import io.cucumber.gherkin.GherkinDialect;
import io.cucumber.gherkin.GherkinDialects;
import io.cucumber.gherkin.GherkinParser;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.Source;
import io.cucumber.messages.types.SourceMediaType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;

public final class GherkinEditorDocument
extends GherkinStream {
    private static final List<Function<GherkinDialect, List<String>>> STEP_KEYWORD_KEYS = Arrays.asList(GherkinDialect::getGivenKeywords, GherkinDialect::getWhenKeywords, GherkinDialect::getThenKeywords, GherkinDialect::getAndKeywords, GherkinDialect::getButKeywords);
    private static final List<Function<GherkinDialect, List<String>>> TOP_LEVEL_KEYWORD = Arrays.asList(GherkinDialect::getScenarioKeywords, GherkinDialect::getScenarioOutlineKeywords, GherkinDialect::getRuleKeywords, GherkinDialect::getBackgroundKeywords, GherkinDialect::getExamplesKeywords);
    private final IDocument document;
    private final GherkinDialect dialect;
    private final Locale locale;
    private Supplier<IResource> resourceSupplier;

    GherkinEditorDocument(IDocument document, Supplier<IResource> resourceSupplier) {
        super(GherkinEditorDocument.getEnvelopes(document));
        this.resourceSupplier = resourceSupplier;
        this.document = document;
        Optional<String> langOpt = this.getFeature().map(f -> f.getLanguage()).filter(Objects::nonNull).filter(Predicate.not(String::isBlank));
        this.dialect = (GherkinDialect)langOpt.flatMap(lang -> GherkinDialects.getDialect((String)lang)).or(() -> {
            try {
                String[] split;
                IRegion firstLine = document.getLineInformation(0);
                String line = document.get(firstLine.getOffset(), firstLine.getLength()).trim();
                if (line.startsWith("#") && (split = line.split("language:", 2)).length == 2) {
                    try {
                        return GherkinDialects.getDialect((String)split[1].trim());
                    }
                    catch (Exception exception) {}
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return Optional.empty();
        }).or(() -> GherkinDialects.getDialect((String)"en")).orElseThrow(() -> new IllegalStateException("Can't find any dialect for the document!"));
        this.locale = Locale.forLanguageTag(this.dialect.getLanguage());
    }

    private static Envelope[] getEnvelopes(IDocument document) {
        GherkinParser parser = GherkinParser.builder().includeSource(true).includeGherkinDocument(true).includePickles(false).build();
        Source source = new Source("", document.get(), SourceMediaType.TEXT_X_CUCUMBER_GHERKIN_PLAIN);
        Envelope envelope = Envelope.of((Source)source);
        return (Envelope[])parser.parse(envelope).toArray(Envelope[]::new);
    }

    public GherkinDialect getDialect() {
        return this.dialect;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public IDocument getDocument() {
        return this.document;
    }

    public Position getPosition(Location location) throws BadLocationException {
        return this.getPosition(location, 0);
    }

    public Position getPosition(Location location, int lineOffset) throws BadLocationException {
        int line = location.getLine().intValue();
        int offset = this.document.getLineOffset(line - 1 - lineOffset);
        return new Position(offset + location.getColumn().orElse(0L).intValue() - 1, 1);
    }

    public Position getEolPosition(Location location) throws BadLocationException {
        int line = location.getLine().intValue();
        int offset = this.document.getLineOffset(line - 1);
        int lineLength = this.document.getLineLength(line - 1);
        if (lineLength == 0) {
            return new Position(offset + lineLength, 1);
        }
        if (lineLength == 1) {
            char c = this.document.get(offset, 1).charAt(0);
            if (c == '\n' || c == '\r') {
                return new Position(offset, 1);
            }
            return new Position(offset + 1, 1);
        }
        char c = this.document.get(offset + lineLength - 2, 1).charAt(0);
        int eolOffset = c == '\r' ? 2 : 1;
        return new Position(offset + lineLength - eolOffset, 1);
    }

    public Stream<GherkinKeyword> getStepElementKeywords() {
        return STEP_KEYWORD_KEYS.stream().flatMap(this::keyWords);
    }

    public Stream<GherkinKeyword> getTopLevelKeywords() {
        return TOP_LEVEL_KEYWORD.stream().flatMap(this::keyWords);
    }

    public Stream<GherkinKeyword> getAllKeywords() {
        return Stream.concat(Stream.concat(this.getTopLevelKeywords(), this.getStepElementKeywords()), this.getFeatureKeywords());
    }

    public Stream<GherkinKeyword> getFeatureKeywords() {
        return this.keyWords(GherkinDialect::getFeatureKeywords);
    }

    public Optional<GherkinKeyword> getKeyWordOfLine(String line) {
        String typed = line.stripLeading();
        Optional<GherkinKeyword> keywordPrefix = this.getStepElementKeywords().sorted(Collections.reverseOrder((s1, s2) -> s1.getKey().length() - s2.getKey().length())).filter(keyWord -> typed.startsWith(keyWord.getKey() + " ")).findFirst();
        return keywordPrefix;
    }

    public Stream<GherkinKeyword> keyWords(Function<GherkinDialect, List<String>> keyWords) {
        return keyWords.apply(this.dialect).stream().map(s -> s.trim()).filter(Predicate.not(GherkinEditorDocument::isWildcard)).map(str -> new GherkinKeyword((String)str, this.locale, this.dialect));
    }

    public IResource getResource() {
        return this.resourceSupplier.get();
    }

    static GherkinEditorDocument create(IDocument document, Supplier<IResource> resource) {
        return new GherkinEditorDocument(document, resource);
    }

    private static boolean isWildcard(String keyword) {
        return "*".equals(keyword);
    }
}

