/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.document;

import io.cucumber.eclipse.editor.document.FileBasedDocument;
import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.editor.document.IGherkinDocumentListener;
import io.cucumber.eclipse.editor.document.TrackedResourceDocument;
import io.cucumber.eclipse.editor.validation.BatchUpdater;
import io.cucumber.eclipse.editor.validation.DocumentValidator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;

public final class GherkinEditorDocumentManager {
    private static final ConcurrentHashMap<IDocument, GherkinEditorDocument> DOCUMENT_MAP = new ConcurrentHashMap();
    private static final List<IGherkinDocumentListener> LISTENERS = new CopyOnWriteArrayList<IGherkinDocumentListener>();
    private static final ConcurrentHashMap<IFile, TrackedResourceDocument> TRACKED_RESOURCES = new ConcurrentHashMap();
    private static IResourceChangeListener resourceChangeListener;

    private GherkinEditorDocumentManager() {
    }

    public static GherkinEditorDocument get(IDocument document) {
        return GherkinEditorDocumentManager.get(document, false);
    }

    public static GherkinEditorDocument get(IDocument document, boolean create) {
        Objects.requireNonNull(document, "document can't be null");
        if (GherkinEditorDocumentManager.isCompatibleTextBuffer(document)) {
            return DOCUMENT_MAP.computeIfAbsent(document, key -> GherkinEditorDocument.create(key, () -> GherkinEditorDocumentManager.resourceForDocument(key)));
        }
        if (create) {
            return GherkinEditorDocument.create(document, () -> null);
        }
        return null;
    }

    public static GherkinEditorDocument get(IResource resource) {
        return GherkinEditorDocumentManager.get(resource, false);
    }

    public static GherkinEditorDocument get(IResource resource, boolean track) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
            if (buffer != null) {
                return GherkinEditorDocumentManager.get(buffer.getDocument());
            }
            if (track) {
                GherkinEditorDocumentManager.ensureResourceListenerInstalled();
                TrackedResourceDocument trackedDocument = TRACKED_RESOURCES.computeIfAbsent(file, TrackedResourceDocument::new);
                return trackedDocument.getDocument(true);
            }
            TrackedResourceDocument trackedDocument = TRACKED_RESOURCES.get(file);
            if (trackedDocument != null) {
                return trackedDocument.getDocument(true);
            }
            return FileBasedDocument.loadFromFile(file);
        }
        return null;
    }

    public static boolean isCompatibleTextBuffer(IDocument document) {
        ITextFileBuffer buffer;
        if (document != null && (buffer = GherkinEditorDocumentManager.getTextBuffer(document)) != null) {
            try {
                IContentType contentType = buffer.getContentType();
                if (contentType != null) {
                    return "io.cucumber.eclipse.editor.content-type.feature".equals(contentType.getId());
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    public static ITextFileBuffer getTextBuffer(IDocument document) {
        return FileBuffers.getTextFileBufferManager().getTextFileBuffer(document);
    }

    public static IResource resourceForDocument(IDocument document) {
        IFile res;
        IPath location;
        if (document instanceof FileBasedDocument) {
            FileBasedDocument rb = (FileBasedDocument)document;
            return rb.getFile();
        }
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(document);
        if (buffer != null && (location = buffer.getLocation()) != null && (res = ResourcesPlugin.getWorkspace().getRoot().getFile(location)) != null && res.exists()) {
            return res;
        }
        return null;
    }

    public static void addDocumentListener(IGherkinDocumentListener listener) {
        if (listener != null && !LISTENERS.contains(listener)) {
            LISTENERS.add(listener);
        }
    }

    public static void removeDocumentListener(IGherkinDocumentListener listener) {
        LISTENERS.remove(listener);
    }

    static void textBufferCreated(IDocument document) {
        GherkinEditorDocumentManager.fireDocumentCreated(document);
    }

    static void documentLoaded(IDocument document) {
        GherkinEditorDocumentManager.fireDocumentCreated(document);
    }

    private static void fireDocumentCreated(IDocument document) {
        for (IGherkinDocumentListener listener : LISTENERS) {
            try {
                listener.documentCreated(document);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void textBufferChanged(IDocument document) {
        DOCUMENT_MAP.remove(document);
        GherkinEditorDocumentManager.fireDocumentChanged(document);
    }

    private static void fireDocumentChanged(IDocument document) {
        for (IGherkinDocumentListener listener : LISTENERS) {
            try {
                listener.documentChanged(document);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void textBufferRemoved(IDocument document) {
        GherkinEditorDocument removed = DOCUMENT_MAP.remove(document);
        if (removed != null) {
            GherkinEditorDocumentManager.fireDocumentRemoved(document);
        }
    }

    private static void fireDocumentRemoved(IDocument document) {
        for (IGherkinDocumentListener listener : LISTENERS) {
            try {
                listener.documentDisposed(document);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static synchronized void ensureResourceListenerInstalled() {
        if (resourceChangeListener == null) {
            resourceChangeListener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    if (event.getDelta() != null) {
                        try {
                            Throwable throwable = null;
                            Object var3_5 = null;
                            try (BatchUpdater batch = DocumentValidator.batch();){
                                event.getDelta().accept(new IResourceDeltaVisitor(){

                                    public boolean visit(IResourceDelta delta) throws CoreException {
                                        IResource resource = delta.getResource();
                                        if (resource instanceof IFile) {
                                            IFile file = (IFile)resource;
                                            switch (delta.getKind()) {
                                                case 2: {
                                                    GherkinEditorDocumentManager.handleResourceRemoved(TRACKED_RESOURCES.remove(file));
                                                    break;
                                                }
                                                case 4: {
                                                    if ((delta.getFlags() & 0x100) == 0) break;
                                                    GherkinEditorDocumentManager.handleResourceChanged(TRACKED_RESOURCES.get(file));
                                                }
                                            }
                                        }
                                        return true;
                                    }
                                });
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                }
            };
            ResourcesPlugin.getWorkspace().addResourceChangeListener(resourceChangeListener, 1);
        }
    }

    private static void handleResourceRemoved(TrackedResourceDocument removed) {
        if (removed == null) {
            return;
        }
        if (GherkinEditorDocumentManager.isMappedToBuffer(removed.getFile())) {
            return;
        }
        GherkinEditorDocument document = removed.getDocument(false);
        if (document == null) {
            GherkinEditorDocumentManager.fireDocumentRemoved((IDocument)new FileBasedDocument(removed.getFile()));
        } else {
            GherkinEditorDocumentManager.fireDocumentRemoved(document.getDocument());
        }
    }

    private static void handleResourceChanged(TrackedResourceDocument changed) {
        if (changed == null) {
            return;
        }
        if (GherkinEditorDocumentManager.isMappedToBuffer(changed.getFile())) {
            return;
        }
        GherkinEditorDocument document = changed.reloadDocument();
        if (document == null) {
            GherkinEditorDocumentManager.fireDocumentRemoved((IDocument)new FileBasedDocument(changed.getFile()));
        } else {
            GherkinEditorDocumentManager.fireDocumentChanged(document.getDocument());
        }
    }

    private static boolean isMappedToBuffer(IFile file) {
        return FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE) != null;
    }
}

