/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.document;

import io.cucumber.eclipse.editor.document.GherkinStream;
import io.cucumber.eclipse.editor.document.TestStepEvent;
import io.cucumber.eclipse.editor.launching.EnvelopeListener;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.StepDefinition;
import io.cucumber.messages.types.TestCase;
import io.cucumber.messages.types.TestStep;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepStarted;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public abstract class GherkinMessageHandler
implements EnvelopeListener {
    private GherkinStream stream;
    private Map<String, PickleStepLink> pickleStepMap = new ConcurrentHashMap<String, PickleStepLink>();
    private Map<String, TestStepLink> testStepMap = new ConcurrentHashMap<String, TestStepLink>();
    private Map<String, StepDefinition> stepDefinitionMap = new ConcurrentHashMap<String, StepDefinition>();

    @Override
    public void handleEnvelope(Envelope env) {
        if (env.getTestCase().isPresent()) {
            TestCase testCase = (TestCase)env.getTestCase().get();
            for (TestStep step : testCase.getTestSteps()) {
                this.testStepMap.put(step.getId(), new TestStepLink(step));
            }
            return;
        }
        if (env.getPickle().isPresent()) {
            Pickle pickle = (Pickle)env.getPickle().get();
            for (PickleStep step : pickle.getSteps()) {
                this.pickleStepMap.put(step.getId(), new PickleStepLink(step));
            }
            return;
        }
        if (env.getGherkinDocument().isPresent()) {
            this.stream = new GherkinStream(env);
            return;
        }
        if (env.getStepDefinition().isPresent()) {
            StepDefinition stepDefinition = (StepDefinition)env.getStepDefinition().get();
            this.stepDefinitionMap.put(stepDefinition.getId(), stepDefinition);
            return;
        }
        boolean testStepStarted = env.getTestStepStarted().isPresent();
        boolean testStepFinished = env.getTestStepFinished().isPresent();
        if (testStepStarted || testStepFinished) {
            TestStepLink stepLink;
            if (testStepStarted) {
                TestStepStarted stepStarted = (TestStepStarted)env.getTestStepStarted().get();
                stepLink = this.testStepMap.get(stepStarted.getTestStepId());
            } else if (testStepFinished) {
                TestStepFinished stepFinished = (TestStepFinished)env.getTestStepFinished().get();
                stepLink = this.testStepMap.get(stepFinished.getTestStepId());
            } else {
                stepLink = null;
            }
            if (stepLink != null) {
                stepLink.link().flatMap(link -> link.backtrace().map(backtrace -> {
                    StepDefinition stepDefinition = stepLink.stepDefinitions().findFirst().orElse(null);
                    return new TestStepEvent(backtrace.feature, backtrace.scenario, backtrace.step, testStepLink.testStep, stepDefinition);
                })).ifPresent(event -> {
                    if (testStepStarted) {
                        this.handleTestStepStart((TestStepEvent)event);
                    }
                });
            }
            return;
        }
    }

    protected abstract void handleTestStepStart(TestStepEvent var1);

    static /* synthetic */ Map access$0(GherkinMessageHandler gherkinMessageHandler) {
        return gherkinMessageHandler.pickleStepMap;
    }

    static /* synthetic */ Map access$1(GherkinMessageHandler gherkinMessageHandler) {
        return gherkinMessageHandler.stepDefinitionMap;
    }

    private final class Backtrace {
        final Feature feature;
        final Scenario scenario;
        final Step step;

        public Backtrace(Feature feature, Scenario scenario, Step step) {
            this.feature = feature;
            this.scenario = scenario;
            this.step = step;
        }
    }

    private final class PickleStepLink {
        private PickleStep step;

        public PickleStepLink(PickleStep step) {
            this.step = step;
        }

        Optional<Backtrace> backtrace() {
            if (GherkinMessageHandler.this.stream != null) {
                return this.step.getAstNodeIds().stream().flatMap(astId -> this.findByAst((String)astId)).findAny();
            }
            return Optional.empty();
        }

        private Stream<Backtrace> findByAst(String astId) {
            return GherkinMessageHandler.this.stream.getFeature().flatMap(feature -> GherkinStream.scenarios(feature).flatMap(scenario -> GherkinStream.scenarioSteps(scenario).filter(step -> step.getId().equals(astId)).findAny().map(step -> new Backtrace((Feature)feature, (Scenario)scenario, (Step)step)).stream()).findAny()).stream();
        }
    }

    private final class TestStepLink {
        private TestStep testStep;

        public TestStepLink(TestStep step) {
            this.testStep = step;
        }

        Optional<PickleStepLink> link() {
            return this.testStep.getPickleStepId().flatMap(id -> Optional.ofNullable(GherkinMessageHandler.this.pickleStepMap.get(id)));
        }

        Stream<StepDefinition> stepDefinitions() {
            return this.testStep.getStepDefinitionIds().map(l -> l.stream().map(GherkinMessageHandler.this.stepDefinitionMap::get).filter(Objects::nonNull)).orElse(Stream.of(new StepDefinition[0]));
        }
    }
}

