/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.document;

import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.DataTable;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.ParseError;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TableRow;
import io.cucumber.messages.types.Tag;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class GherkinStream {
    private final Envelope[] envelopes;

    public GherkinStream(Envelope ... envelopes) {
        this.envelopes = envelopes;
    }

    public Optional<Feature> getFeature() {
        return this.getGherkinDocument().flatMap(GherkinDocument::getFeature);
    }

    public Optional<GherkinDocument> getGherkinDocument() {
        return Arrays.stream(this.envelopes).map(s -> s.getGherkinDocument()).filter(o -> o.isPresent()).map(o -> (GherkinDocument)o.get()).findFirst();
    }

    public Stream<FeatureChild> getFeatureChilds() {
        return this.getFeature().stream().flatMap(GherkinStream::featureChilds);
    }

    public static Stream<FeatureChild> featureChilds(Feature feature) {
        return feature.getChildren().stream();
    }

    public Stream<Scenario> getScenarios() {
        return this.getFeatureChilds().map(FeatureChild::getScenario).filter(o -> o.isPresent()).map(o -> (Scenario)o.get());
    }

    public static Stream<Scenario> scenarios(Feature feature) {
        return GherkinStream.featureChilds(feature).map(FeatureChild::getScenario).filter(o -> o.isPresent()).map(o -> (Scenario)o.get());
    }

    public Stream<Step> getSteps() {
        Stream backgroundSteps = this.getBackgrounds().flatMap(bg -> bg.getSteps().stream());
        Stream scenarioSteps = this.getScenarios().flatMap(GherkinStream::scenarioSteps);
        return Stream.concat(scenarioSteps, backgroundSteps).distinct();
    }

    public static Stream<Step> scenarioSteps(Scenario scenario) {
        return scenario.getSteps().stream();
    }

    public Stream<Background> getBackgrounds() {
        return this.getFeatureChilds().map(FeatureChild::getBackground).filter(o -> o.isPresent()).map(o -> (Background)o.get());
    }

    public Stream<Tag> getTags() {
        return Stream.concat(this.getExamples().flatMap(example -> example.getTags().stream()), Stream.concat(this.getScenarios().flatMap(scenario -> scenario.getTags().stream()), this.getFeature().stream().flatMap(feature -> feature.getTags().stream()))).distinct();
    }

    public Stream<Examples> getExamples() {
        return this.getScenarios().flatMap(s -> s.getExamples().stream());
    }

    public Stream<TableRow> getTableHeaders() {
        return this.getExamples().map(Examples::getTableHeader).filter(o -> o.isPresent()).map(o -> (TableRow)o.get()).distinct();
    }

    public Stream<List<TableRow>> getTableBodys() {
        return this.getExamples().filter(e -> e.getTableHeader().isPresent()).map(Examples::getTableBody).distinct();
    }

    public Stream<DataTable> getDataTables() {
        return this.getScenarios().flatMap(scenario -> scenario.getSteps().stream()).map(Step::getDataTable).filter(o -> o.isPresent()).map(o -> (DataTable)o.get()).distinct();
    }

    public Stream<ParseError> getParseError() {
        return Arrays.stream(this.envelopes).map(Envelope::getParseError).filter(o -> o.isPresent()).map(o -> (ParseError)o.get());
    }
}

