/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.document;

import io.cucumber.eclipse.editor.document.FileBasedDocument;
import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.editor.document.GherkinEditorDocumentManager;
import java.io.IOException;
import java.lang.ref.WeakReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jface.text.IDocument;

final class TrackedResourceDocument {
    private final IFile file;
    private WeakReference<GherkinEditorDocument> documentRef;

    TrackedResourceDocument(IFile resource) {
        this.file = resource;
    }

    public synchronized GherkinEditorDocument getDocument(boolean load) {
        GherkinEditorDocument document;
        GherkinEditorDocument gherkinEditorDocument = document = this.documentRef == null ? null : (GherkinEditorDocument)this.documentRef.get();
        if (load && document == null) {
            return this.loadDocument();
        }
        return document;
    }

    public synchronized GherkinEditorDocument reloadDocument() {
        IDocument document;
        GherkinEditorDocument editorDocument;
        if (this.documentRef != null && (editorDocument = (GherkinEditorDocument)this.documentRef.get()) != null && (document = editorDocument.getDocument()) instanceof FileBasedDocument) {
            FileBasedDocument resourceDocument = (FileBasedDocument)document;
            try {
                resourceDocument.reload();
                GherkinEditorDocument reloaded = new GherkinEditorDocument(document, () -> this.file);
                this.documentRef = new WeakReference<GherkinEditorDocument>(reloaded);
                return reloaded;
            }
            catch (IOException | CoreException e) {
                ILog.get().warn("Failed to reload document for " + String.valueOf(this.file.getFullPath()), e);
            }
        }
        return this.loadDocument();
    }

    private synchronized GherkinEditorDocument loadDocument() {
        GherkinEditorDocument editorDocument = FileBasedDocument.loadFromFile(this.file);
        if (editorDocument != null) {
            boolean isInitialLoad = this.documentRef == null;
            this.documentRef = new WeakReference<GherkinEditorDocument>(editorDocument);
            if (isInitialLoad) {
                GherkinEditorDocumentManager.documentLoaded(editorDocument.getDocument());
            }
        }
        return editorDocument;
    }

    public IFile getFile() {
        return this.file;
    }
}

