/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.launching;

import io.cucumber.eclipse.editor.CucumberServiceRegistry;
import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.editor.document.GherkinEditorDocumentManager;
import io.cucumber.eclipse.editor.launching.ILauncher;
import io.cucumber.eclipse.editor.launching.Mode;
import io.cucumber.messages.types.Feature;
import io.cucumber.tagexpressions.TagExpressionParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class CucumberFeatureLaunchShortcut
implements ILaunchShortcut {
    private static final ILauncher NO_LAUNCHER = new ILauncher(){

        @Override
        public void launch(Map<GherkinEditorDocument, IStructuredSelection> selection, Mode mode, boolean temporary, IProgressMonitor monitor) {
        }

        @Override
        public boolean supports(IResource resource) {
            return true;
        }

        @Override
        public boolean supports(Mode mode) {
            return true;
        }
    };

    public void launch(IEditorPart editor, String mode) {
        final Mode modeType = Mode.parseString(mode);
        if (modeType == null) {
            return;
        }
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            IEditorInput editorInput = textEditor.getEditorInput();
            final IDocument document = textEditor.getDocumentProvider().getDocument((Object)editorInput);
            final ISelection selection = textEditor.getSelectionProvider().getSelection();
            if (document != null) {
                Job.create((String)"Launching Cucumber", (ICoreRunnable)new ICoreRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        GherkinEditorDocument editorDocument = GherkinEditorDocumentManager.get(document);
                        Optional<Feature> feature = editorDocument.getFeature();
                        if (feature.isPresent()) {
                            StructuredSelection selected;
                            ILauncher launcher = CucumberFeatureLaunchShortcut.getLauncher(modeType).filter(l -> l.supports(editorDocument.getResource())).findAny().orElse(NO_LAUNCHER);
                            if (!selection.isEmpty() && selection instanceof ITextSelection) {
                                ITextSelection textSelection = (ITextSelection)selection;
                                int startLine = textSelection.getStartLine() + 1;
                                int endLine = textSelection.getEndLine() + 1;
                                ArrayList<Feature> selectedItems = new ArrayList<Feature>();
                                editorDocument.getTags().filter(tag -> tag.getLocation().getLine() >= (long)startLine && tag.getLocation().getLine() <= (long)endLine).map(tag -> TagExpressionParser.parse((String)tag.getName())).forEach(selectedItems::add);
                                editorDocument.getScenarios().filter(senario -> senario.getLocation().getLine() >= (long)startLine && senario.getLocation().getLine() <= (long)endLine).forEach(selectedItems::add);
                                if (selectedItems.isEmpty()) {
                                    selectedItems.add(feature.get());
                                }
                                selected = new StructuredSelection(selectedItems);
                            } else {
                                selected = new StructuredSelection((Object)feature.get());
                            }
                            launcher.launch(editorDocument, (IStructuredSelection)selected, modeType, true, monitor);
                        }
                    }
                }).schedule();
            }
        }
    }

    public void launch(final ISelection selection, String mode) {
        final Mode modeType = Mode.parseString(mode);
        if (modeType == null) {
            return;
        }
        Job.create((String)"Launching Cucumber", (ICoreRunnable)new ICoreRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (selection instanceof StructuredSelection) {
                    Map documents = Arrays.stream(((StructuredSelection)selection).toArray()).map(o -> (IFile)Adapters.adapt((Object)o, IFile.class)).filter(Objects::nonNull).map(GherkinEditorDocumentManager::get).filter(doc -> doc.getFeature().isPresent()).collect(Collectors.toMap(Function.identity(), doc -> new StructuredSelection((Object)doc.getFeature().get())));
                    documents.isEmpty();
                    List launcher = CucumberFeatureLaunchShortcut.getLauncher(modeType).collect(Collectors.toList());
                    Map<ILauncher, List<Map.Entry>> launchMap = documents.entrySet().stream().collect(Collectors.groupingBy(entry -> launcher.stream().filter(l -> l.supports(((GherkinEditorDocument)entry.getKey()).getResource())).findAny().orElse(NO_LAUNCHER)));
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(launchMap.size() * 100));
                    for (Map.Entry<ILauncher, List<Map.Entry>> entry2 : launchMap.entrySet()) {
                        entry2.getKey().launch(entry2.getValue().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), modeType, false, (IProgressMonitor)subMonitor.split(100));
                    }
                }
            }
        }).schedule();
    }

    private static Stream<ILauncher> getLauncher(Mode modeType) {
        return CucumberServiceRegistry.getLauncher().stream().filter(l -> l.supports(modeType));
    }

    static /* synthetic */ ILauncher access$0() {
        return NO_LAUNCHER;
    }
}

