/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.preferences;

import io.cucumber.eclipse.editor.Activator;
import io.cucumber.eclipse.editor.launching.Mode;
import io.cucumber.eclipse.editor.properties.CucumberEditorProperties;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;

public record CucumberEditorPreferences(IPreferenceStore store, IEclipsePreferences node) {
    static final String PREF_SHOW_RUN_SHORTCUT_PREFIX = "io.cucumber.eclipse.editor.show_run_shortcut_";
    static final String PREF_VALIDATION_TIMEOUT = "io.cucumber.eclipse.editor.validation_timeout";
    public static final int DEFAULT_VALIDATION_TIMEOUT = 500;

    public static CucumberEditorPreferences of() {
        return CucumberEditorPreferences.of(null);
    }

    public static CucumberEditorPreferences of(IResource resource) {
        CucumberEditorProperties properties;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (resource != null && (properties = CucumberEditorProperties.of(resource)).isEnabled()) {
            return new CucumberEditorPreferences(store, properties.node());
        }
        return new CucumberEditorPreferences(store, null);
    }

    public boolean isShowShortcutFor(Mode mode) {
        if (this.node != null) {
            return this.node.getBoolean("showShortcut" + mode.name(), true);
        }
        return this.store.getBoolean(PREF_SHOW_RUN_SHORTCUT_PREFIX + mode.name());
    }

    public static void setShowShortcutFor(Mode mode, boolean show) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        CucumberEditorPreferences.setShowShortcutFor(store, mode, show);
    }

    protected static void setShowShortcutFor(IPreferenceStore store, Mode mode, boolean show) {
        store.setValue(PREF_SHOW_RUN_SHORTCUT_PREFIX + mode.name(), show);
    }

    public int getValidationTimeout() {
        if (this.node != null) {
            int timeout = this.node.getInt("validationTimeout", 500);
            return timeout > 0 ? timeout : 500;
        }
        int timeout = this.store.getInt(PREF_VALIDATION_TIMEOUT);
        return timeout > 0 ? timeout : 500;
    }

    public static void setValidationTimeout(IPreferenceStore store, int timeout) {
        store.setValue(PREF_VALIDATION_TIMEOUT, timeout);
    }
}

