/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.properties;

import io.cucumber.eclipse.editor.launching.Mode;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public record CucumberEditorProperties(IEclipsePreferences node) {
    private static final String NAMESPACE = "io.cucumber.eclipse.editor";
    static final String KEY_ENABLE_PROJECT_SPECIFIC_SETTINGS = "enableProjectSpecific";
    public static final String KEY_SHOW_LAUNCH_SHORTCUT_PREFIX = "showShortcut";
    public static final String KEY_VALIDATION_TIMEOUT = "validationTimeout";

    public static CucumberEditorProperties of(IResource resource) {
        if (resource == null) {
            return new CucumberEditorProperties(null);
        }
        IEclipsePreferences node = CucumberEditorProperties.getNode(resource);
        return new CucumberEditorProperties(node);
    }

    public boolean isEnabled() {
        if (this.node == null) {
            return false;
        }
        return this.node.getBoolean(KEY_ENABLE_PROJECT_SPECIFIC_SETTINGS, false);
    }

    public void setEnabled(boolean enabled) {
        if (this.node == null) {
            return;
        }
        this.node.putBoolean(KEY_ENABLE_PROJECT_SPECIFIC_SETTINGS, enabled);
        this.flush();
    }

    public void flush() {
        if (this.node == null) {
            return;
        }
        try {
            this.node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    static IEclipsePreferences getNode(IResource resource) {
        ProjectScope scope = new ProjectScope(resource.getProject());
        IEclipsePreferences node = scope.getNode(NAMESPACE);
        return node;
    }

    public boolean isShowShortcutFor(Mode mode) {
        if (this.node == null) {
            return true;
        }
        return this.node.getBoolean(KEY_SHOW_LAUNCH_SHORTCUT_PREFIX + mode.name(), true);
    }

    public void setShowShortcutFor(Mode mode, boolean show) {
        if (this.node == null) {
            return;
        }
        this.node.putBoolean(KEY_SHOW_LAUNCH_SHORTCUT_PREFIX + mode.name(), show);
    }

    public int getValidationTimeout() {
        if (this.node == null) {
            return 500;
        }
        int timeout = this.node.getInt(KEY_VALIDATION_TIMEOUT, 500);
        return timeout > 0 ? timeout : 500;
    }

    public void setValidationTimeout(int timeout) {
        if (this.node == null) {
            return;
        }
        this.node.putInt(KEY_VALIDATION_TIMEOUT, timeout);
    }
}

