/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.properties;

import io.cucumber.eclipse.editor.EditorReconciler;
import io.cucumber.eclipse.editor.Images;
import io.cucumber.eclipse.editor.launching.Mode;
import io.cucumber.eclipse.editor.preferences.CucumberPreferencePage;
import io.cucumber.eclipse.editor.properties.CucumberEditorProperties;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class CucumberPropertiesPage
extends PropertyPage {
    private Map<Mode, Button> modeButtons = new HashMap<Mode, Button>();
    private Button enableProjectSpecific;
    private Text validationTimeoutText;
    private Label timeoutLabel;

    public CucumberPropertiesPage() {
        this.setTitle("Cucumber");
        this.setDescription("You can configure Cucumber related properties for your project here");
        this.setImageDescriptor(Images.getCukesIconDescriptor());
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        IResource resource = this.getResource();
        IEclipsePreferences node = CucumberEditorProperties.getNode(resource);
        this.enableProjectSpecific = new Button(composite, 32);
        this.enableProjectSpecific.setText("Enable project specific settings");
        this.enableProjectSpecific.setSelection(node.getBoolean("enableProjectSpecific", false));
        this.enableProjectSpecific.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CucumberPropertiesPage.this.updateUI();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData enableData = new GridData(4, 0x1000000, true, false);
        enableData.horizontalSpan = 2;
        this.enableProjectSpecific.setLayoutData((Object)enableData);
        Mode[] modeArray = Mode.values();
        int n = modeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Mode mode = modeArray[n2];
            Button button = new Button(composite, 32);
            button.setSelection(node.getBoolean("showShortcut" + mode.name(), true));
            button.setText(CucumberPreferencePage.getLabelForMode(mode));
            GridData buttonData = new GridData(4, 0x1000000, true, false);
            buttonData.horizontalSpan = 2;
            button.setLayoutData((Object)buttonData);
            this.modeButtons.put(mode, button);
            ++n2;
        }
        this.timeoutLabel = new Label(composite, 0);
        this.timeoutLabel.setText("Validation timeout (ms):");
        this.timeoutLabel.setToolTipText("Time to wait after typing before validating feature files (milliseconds)");
        this.validationTimeoutText = new Text(composite, 2052);
        GridData timeoutData = new GridData(100, -1);
        this.validationTimeoutText.setLayoutData((Object)timeoutData);
        this.validationTimeoutText.setText(String.valueOf(node.getInt("validationTimeout", 500)));
        this.validationTimeoutText.setToolTipText("Time to wait after typing before validating feature files (milliseconds)");
        this.updateUI();
        return composite;
    }

    protected void updateUI() {
        boolean enable = this.enableProjectSpecific.getSelection();
        for (Button b : this.modeButtons.values()) {
            b.setEnabled(enable);
        }
        this.validationTimeoutText.setEnabled(enable);
        this.timeoutLabel.setEnabled(enable);
    }

    private IResource getResource() {
        return (IResource)this.getElement().getAdapter(IResource.class);
    }

    public boolean performOk() {
        IEclipsePreferences node;
        block4: {
            node = CucumberEditorProperties.getNode(this.getResource());
            node.putBoolean("enableProjectSpecific", this.enableProjectSpecific.getSelection());
            for (Map.Entry<Mode, Button> entry : this.modeButtons.entrySet()) {
                node.putBoolean("showShortcut" + entry.getKey().name(), entry.getValue().getSelection());
            }
            try {
                int timeout = Integer.parseInt(this.validationTimeoutText.getText().trim());
                if (timeout > 0) {
                    node.putInt("validationTimeout", timeout);
                    break block4;
                }
                this.setErrorMessage("Validation timeout must be a positive number");
                return false;
            }
            catch (NumberFormatException e) {
                this.setErrorMessage("Validation timeout must be a valid number");
                return false;
            }
        }
        CucumberEditorProperties properties = new CucumberEditorProperties(node);
        properties.flush();
        EditorReconciler.reconcileAllFeatureEditors();
        return true;
    }
}

