/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.steps;

import io.cucumber.eclipse.editor.ResourceHelper;
import io.cucumber.eclipse.editor.StorageHelper;
import io.cucumber.eclipse.editor.steps.StepDefinition;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class StepDefinitionsRepository
implements Externalizable {
    private static final long serialVersionUID = -5426643465030832989L;
    private final Map<IResource, Set<StepDefinition>> stepDefinitionsByResourceName = new HashMap<IResource, Set<StepDefinition>>();

    public synchronized void add(IResource stepDefinitionsFile, Set<StepDefinition> steps) {
        if (steps.isEmpty()) {
            this.stepDefinitionsByResourceName.remove(stepDefinitionsFile);
        } else {
            this.stepDefinitionsByResourceName.put(stepDefinitionsFile, steps);
        }
    }

    public Set<IFile> getAllStepDefinitionsFiles() {
        HashSet<IFile> fromFilesOnly = new HashSet<IFile>();
        for (IResource resource : this.stepDefinitionsByResourceName.keySet()) {
            if (!(resource instanceof IFile)) continue;
            fromFilesOnly.add((IFile)resource);
        }
        return fromFilesOnly;
    }

    public Set<StepDefinition> getAllStepDefinitions() {
        HashSet<StepDefinition> allSteps = new HashSet<StepDefinition>();
        for (Set<StepDefinition> steps : this.stepDefinitionsByResourceName.values()) {
            allSteps.addAll(steps);
        }
        return allSteps;
    }

    public boolean isStepDefinitionsResource(IResource resource) {
        return this.stepDefinitionsByResourceName.containsKey(resource);
    }

    public void reset() {
        this.stepDefinitionsByResourceName.clear();
    }

    @Override
    public synchronized void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.stepDefinitionsByResourceName.clear();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            String key = (String)in.readObject();
            IResource resource = ResourceHelper.find(key);
            int childSize = in.readInt();
            HashSet<StepDefinition> steps = new HashSet<StepDefinition>();
            int j = 0;
            while (j < childSize) {
                StepDefinition step = StorageHelper.readStepDefinition(in);
                if (step != null) {
                    steps.add(step);
                }
                ++j;
            }
            if (resource != null && !steps.isEmpty()) {
                this.stepDefinitionsByResourceName.put(resource, steps);
            }
            ++i;
        }
    }

    @Override
    public synchronized void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.stepDefinitionsByResourceName.size());
        for (Map.Entry<IResource, Set<StepDefinition>> entry : this.stepDefinitionsByResourceName.entrySet()) {
            out.writeObject(entry.getKey().getFullPath().toString());
            Set<StepDefinition> value = entry.getValue();
            out.writeInt(value.size());
            for (StepDefinition stepDefinition : value) {
                StorageHelper.writeStepDefinition(stepDefinition, out);
            }
        }
    }
}

