/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.syntaxhighlight;

import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.editor.document.GherkinKeyword;
import io.cucumber.eclipse.editor.syntaxhighlight.GherkinColors;
import io.cucumber.eclipse.editor.syntaxhighlight.GherkinNumericDetector;
import io.cucumber.eclipse.editor.syntaxhighlight.GherkinPlaceholderRule;
import io.cucumber.eclipse.editor.syntaxhighlight.GherkinStarStepWordDetector;
import io.cucumber.eclipse.editor.syntaxhighlight.GherkinTagRule;
import io.cucumber.eclipse.editor.syntaxhighlight.GherkinWhitespaceDetector;
import io.cucumber.eclipse.editor.syntaxhighlight.GherkinWordDetector;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class GherkinKeywordScanner
extends RuleBasedScanner {
    public void configureRules(GherkinEditorDocument document) {
        Token keyword = new Token((Object)new TextAttribute(GherkinColors.KEYWORD.getColor()));
        Token step = new Token((Object)new TextAttribute(GherkinColors.STEP.getColor()));
        Token tag = new Token((Object)new TextAttribute(GherkinColors.TAG.getColor()));
        Token string = new Token((Object)new TextAttribute(GherkinColors.STRING.getColor()));
        Token comment = new Token((Object)new TextAttribute(GherkinColors.COMMENT.getColor()));
        Token other = new Token((Object)new TextAttribute(GherkinColors.DEFAULT.getColor()));
        Token numeric = new Token((Object)new TextAttribute(GherkinColors.NUMERIC.getColor()));
        Token placeholder = new Token((Object)new TextAttribute(GherkinColors.PLACEHOLDER.getColor()));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("#", (IToken)comment));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\\'));
        rules.add(new GherkinTagRule((IToken)tag));
        rules.add(new GherkinPlaceholderRule((IToken)placeholder));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new GherkinWhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new GherkinWordDetector(), (IToken)other);
        WordRule numericRule = new WordRule((IWordDetector)new GherkinNumericDetector(), (IToken)numeric);
        WordRule wordStarStepRule = new WordRule((IWordDetector)new GherkinStarStepWordDetector(), (IToken)step);
        wordStarStepRule.addWord("*", (IToken)keyword);
        document.getTopLevelKeywords().forEach(arg_0 -> GherkinKeywordScanner.lambda$0(rules, (IToken)keyword, arg_0));
        document.getFeatureKeywords().forEach(arg_0 -> GherkinKeywordScanner.lambda$1(rules, (IToken)keyword, arg_0));
        document.getStepElementKeywords().forEach(arg_0 -> GherkinKeywordScanner.lambda$2(rules, (IToken)step, arg_0));
        rules.add(numericRule);
        rules.add(wordRule);
        rules.add(wordStarStepRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    private static /* synthetic */ void lambda$0(List list, IToken iToken, GherkinKeyword e) {
        boolean bl = list.add(new SingleLineRule(e.getKey().trim() + ":", " ", iToken));
    }

    private static /* synthetic */ void lambda$1(List list, IToken iToken, GherkinKeyword e) {
        boolean bl = list.add(new SingleLineRule(e.getKey().trim() + ":", " ", iToken));
    }

    private static /* synthetic */ void lambda$2(List list, IToken iToken, GherkinKeyword e) {
        boolean bl = list.add(new SingleLineRule(e.getKey().trim(), " ", iToken));
    }
}

