/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.testresults;

import io.cucumber.eclipse.editor.launching.EnvelopeListener;
import io.cucumber.eclipse.editor.launching.EnvelopeProvider;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.TestCase;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestStep;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepResult;
import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.messages.types.TestStepStarted;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.unittest.launcher.ITestRunnerClient;
import org.eclipse.unittest.model.ITestElement;
import org.eclipse.unittest.model.ITestRunSession;
import org.eclipse.unittest.model.ITestSuiteElement;

public class CucumberTestRunnerClient
implements ITestRunnerClient,
EnvelopeListener {
    private static final Pattern OPENTEST4J = Pattern.compile("expected:(.*)but was:(.*)");
    private final ITestRunSession session;
    private Map<String, Pickle> pickles = new HashMap<String, Pickle>();
    private Map<String, TestCase> testcases = new HashMap<String, TestCase>();
    private Map<String, TestCaseStarted> started = new HashMap<String, TestCaseStarted>();
    private List<EnvelopeProvider> registered = new ArrayList<EnvelopeProvider>();

    CucumberTestRunnerClient(ITestRunSession session) {
        this.session = session;
    }

    public void stopTest() {
    }

    public void stopMonitoring() {
        CompletableFuture.supplyAsync(() -> {
            for (EnvelopeProvider ep : this.registered) {
                ep.removeEnvelopeListener(this);
            }
            return null;
        });
    }

    public void startMonitoring() {
        IProcess[] processes;
        ILaunch launch = this.session.getLaunch();
        IProcess[] iProcessArray = processes = launch.getProcesses();
        int n = processes.length;
        int n2 = 0;
        while (n2 < n) {
            IProcess process = iProcessArray[n2];
            if (process instanceof EnvelopeProvider) {
                EnvelopeProvider ep = (EnvelopeProvider)process;
                this.registered.add(ep);
                ep.addEnvelopeListener(this);
            }
            ++n2;
        }
    }

    @Override
    public void handleEnvelope(Envelope env) {
        if (env.getTestRunStarted().isPresent()) {
            this.session.notifyTestSessionStarted(null);
            return;
        }
        if (env.getGherkinDocument().isPresent()) {
            GherkinDocument document = (GherkinDocument)env.getGherkinDocument().get();
            Feature feature = (Feature)document.getFeature().get();
            this.session.newTestSuite((String)document.getUri().get(), feature.getName(), null, null, feature.getName(), "");
            return;
        }
        if (env.getPickle().isPresent()) {
            Pickle pickle = (Pickle)env.getPickle().get();
            this.pickles.put(pickle.getId(), pickle);
            return;
        }
        if (env.getTestCase().isPresent()) {
            TestCase testCase = (TestCase)env.getTestCase().get();
            this.testcases.put(testCase.getId(), testCase);
            Pickle pickle = this.pickles.get(testCase.getPickleId());
            Map pickleSteps = pickle.getSteps().stream().collect(Collectors.toMap(PickleStep::getId, Function.identity()));
            ITestSuiteElement testSuite = this.session.newTestSuite(testCase.getId(), pickle.getAstNodeIds().toString(), Integer.valueOf(testCase.getTestSteps().size()), (ITestSuiteElement)this.session.getTestElement(pickle.getUri()), pickle.getName(), env.toString());
            for (TestStep step : testCase.getTestSteps()) {
                Optional pickleStepId = step.getPickleStepId();
                if (pickleStepId.isEmpty() || ((String)pickleStepId.get()).isBlank()) continue;
                PickleStep pickleStep = (PickleStep)pickleSteps.get(pickleStepId.get());
                this.session.newTestCase(step.getId(), pickleStep.getId(), testSuite, pickleStep.getText(), step.toString());
            }
            return;
        }
        if (env.getTestCaseStarted().isPresent()) {
            TestCaseStarted testCaseStarted = (TestCaseStarted)env.getTestCaseStarted().get();
            this.started.put(testCaseStarted.getId(), testCaseStarted);
            return;
        }
        if (env.getTestStepStarted().isPresent()) {
            TestStepStarted testStepStarted = (TestStepStarted)env.getTestStepStarted().get();
            this.session.notifyTestStarted(this.session.getTestElement(testStepStarted.getTestStepId()));
            return;
        }
        if (env.getTestStepFinished().isPresent()) {
            TestStepFinished testStepFinished = (TestStepFinished)env.getTestStepFinished().get();
            TestStepResult testStepResult = testStepFinished.getTestStepResult();
            TestStepResultStatus status = testStepResult.getStatus();
            if (status == TestStepResultStatus.PASSED || status == TestStepResultStatus.PENDING || status == TestStepResultStatus.SKIPPED) {
                this.session.notifyTestEnded(this.session.getTestElement(testStepFinished.getTestStepId()), status != TestStepResultStatus.PASSED);
            } else {
                String expected = null;
                String actual = null;
                String message = (String)testStepResult.getMessage().get();
                Matcher matcher = OPENTEST4J.matcher(message = message.replace("\\r", "\r").replace("\\n", "\n").replace("\\t", "\t"));
                if (matcher.find()) {
                    expected = matcher.group(1).strip();
                    actual = matcher.group(2).strip();
                }
                ITestElement.FailureTrace trace = new ITestElement.FailureTrace(message, expected, actual);
                this.session.notifyTestFailed(this.session.getTestElement(testStepFinished.getTestStepId()), status == TestStepResultStatus.FAILED ? ITestElement.Result.FAILURE : ITestElement.Result.ERROR, status == TestStepResultStatus.UNDEFINED, trace);
            }
            return;
        }
        env.getTestCaseFinished().isPresent();
        if (env.getTestRunFinished().isPresent()) {
            this.session.notifyTestSessionCompleted(null);
            return;
        }
    }
}

