/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.validation;

import io.cucumber.eclipse.editor.validation.BatchVerificationJob;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;

public abstract class BatchUpdater
implements AutoCloseable {
    int references;
    Set<IDocument> documents = new LinkedHashSet<IDocument>();
    Set<IResource> resources = new LinkedHashSet<IResource>();
    private final BatchVerificationJob previousJob;

    BatchUpdater(BatchVerificationJob previousJob) {
        this.previousJob = previousJob;
    }

    void checkForCancel() {
        if (this.previousJob == null) {
            return;
        }
        BatchUpdater updater = this.previousJob.getUpdater();
        if (this.documents.containsAll(updater.documents) && this.resources.containsAll(updater.resources)) {
            this.previousJob.cancel();
        }
    }

    void join(IProgressMonitor monitor) throws InterruptedException {
        if (this.previousJob == null) {
            return;
        }
        this.previousJob.join(0L, monitor);
    }

    @Override
    public abstract void close();
}

