/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.validation;

import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.editor.document.GherkinEditorDocumentManager;
import io.cucumber.eclipse.editor.validation.BatchUpdater;
import io.cucumber.eclipse.editor.validation.IGlueValidator;
import io.cucumber.eclipse.editor.validation.VerificationJob;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;

class BatchVerificationJob
extends VerificationJob {
    private BatchUpdater updater;

    BatchVerificationJob(BatchUpdater updater) {
        super("Features");
        this.updater = updater;
    }

    @Override
    protected IStatus run(IProgressMonitor monitor) {
        monitor.subTask("Wait for previous jobs to complete...");
        try {
            Job.getJobManager().join(VerificationJob.class, monitor);
        }
        catch (InterruptedException | OperationCanceledException e) {
            return Status.CANCEL_STATUS;
        }
        try {
            this.updater.join(monitor);
        }
        catch (InterruptedException e) {
            return Status.CANCEL_STATUS;
        }
        return super.run(monitor);
    }

    @Override
    public boolean belongsTo(Object family) {
        return family == BatchVerificationJob.class || family == IGlueValidator.class;
    }

    @Override
    protected Collection<GherkinEditorDocument> getEditorDocuments() {
        GherkinEditorDocument editorDocument;
        LinkedHashMap<IResource, GherkinEditorDocument> collected = new LinkedHashMap<IResource, GherkinEditorDocument>();
        for (IDocument doc : this.updater.documents) {
            IResource resource;
            editorDocument = GherkinEditorDocumentManager.get(doc);
            if (editorDocument == null || (resource = editorDocument.getResource()) == null) continue;
            collected.put(resource, editorDocument);
        }
        for (IResource resource : this.updater.resources) {
            if (collected.containsKey(resource) || (editorDocument = GherkinEditorDocumentManager.get(resource)) == null) continue;
            collected.put(resource, editorDocument);
        }
        return collected.values();
    }

    public BatchUpdater getUpdater() {
        return this.updater;
    }

    @Override
    public boolean matches(IProject project) {
        for (IDocument doc : this.updater.documents) {
            IResource resource = GherkinEditorDocumentManager.resourceForDocument(doc);
            if (resource == null || resource.getProject() != project) continue;
            return true;
        }
        for (IResource resource : this.updater.resources) {
            if (resource.getProject() != project) continue;
            return true;
        }
        return false;
    }
}

