/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.validation;

import io.cucumber.eclipse.editor.document.GherkinEditorDocumentManager;
import io.cucumber.eclipse.editor.document.IGherkinDocumentListener;
import io.cucumber.eclipse.editor.preferences.CucumberEditorPreferences;
import io.cucumber.eclipse.editor.validation.BatchUpdater;
import io.cucumber.eclipse.editor.validation.BatchVerificationJob;
import io.cucumber.eclipse.editor.validation.IGlueValidator;
import io.cucumber.eclipse.editor.validation.ResourceVerificationJob;
import io.cucumber.eclipse.editor.validation.TextBufferVerificationJob;
import io.cucumber.eclipse.editor.validation.VerificationJob;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;

public class DocumentValidator
implements IGherkinDocumentListener {
    private static final ConcurrentMap<IDocument, VerificationJob> textBufferDocuments = new ConcurrentHashMap<IDocument, VerificationJob>();
    private static final ConcurrentMap<IResource, VerificationJob> resourceDocuments = new ConcurrentHashMap<IResource, VerificationJob>();
    private static final DocumentValidator INSTANCE = new DocumentValidator();
    private BatchUpdater batch;

    private DocumentValidator() {
    }

    public static void initialize() {
        GherkinEditorDocumentManager.addDocumentListener(INSTANCE);
    }

    @Override
    public void documentCreated(IDocument document) {
        DocumentValidator.validate(document, 0);
    }

    @Override
    public void documentChanged(IDocument document) {
        IResource resource = GherkinEditorDocumentManager.resourceForDocument(document);
        if (resource == null) {
            return;
        }
        int timeout = CucumberEditorPreferences.of(resource).getValidationTimeout();
        DocumentValidator.validate(document, timeout);
    }

    @Override
    public void documentDisposed(IDocument document) {
        VerificationJob remove;
        IResource resource;
        VerificationJob job = (VerificationJob)((Object)textBufferDocuments.remove(document));
        if (job != null) {
            job.cancel();
        }
        if ((resource = GherkinEditorDocumentManager.resourceForDocument(document)) != null && (remove = (VerificationJob)((Object)resourceDocuments.remove(resource))) != null) {
            remove.cancel();
        }
    }

    private static void validate(IDocument document, int delay) {
        ITextFileBuffer textBuffer = GherkinEditorDocumentManager.getTextBuffer(document);
        if (textBuffer != null) {
            VerificationJob job = textBufferDocuments.computeIfAbsent(document, doc -> {
                IPath location = textBuffer.getLocation();
                return new TextBufferVerificationJob(document, location == null ? "Document" : location.toOSString());
            });
            if (INSTANCE.addToBatch(document)) {
                return;
            }
            job.schedule(Math.max(0, delay));
            return;
        }
        IResource resource = GherkinEditorDocumentManager.resourceForDocument(document);
        if (resource != null) {
            DocumentValidator.validate(resource, delay);
            return;
        }
    }

    private static void validate(IResource resource, int delay) {
        VerificationJob job = resourceDocuments.computeIfAbsent(resource, ResourceVerificationJob::new);
        if (INSTANCE.addToBatch(resource)) {
            return;
        }
        job.schedule(Math.max(0, delay));
    }

    public static void revalidate(IDocument document) {
        DocumentValidator.validate(document, 0);
    }

    public static void revalidateAllDocuments() {
        HashSet scheduled = new HashSet();
        textBufferDocuments.forEach((doc, job) -> {
            IResource resource = GherkinEditorDocumentManager.resourceForDocument(doc);
            if (resource == null) {
                return;
            }
            if (INSTANCE.addToBatch((IDocument)doc)) {
                return;
            }
            DocumentValidator.scheduleValidation(resource, job);
            scheduled.add(resource);
        });
        resourceDocuments.forEach((resource, job) -> {
            if (scheduled.add(resource)) {
                if (INSTANCE.addToBatch((IResource)resource)) {
                    return;
                }
                DocumentValidator.scheduleValidation(resource, job);
            }
        });
    }

    private static void scheduleValidation(IResource resource, VerificationJob job) {
        int timeout = CucumberEditorPreferences.of(resource).getValidationTimeout();
        job.schedule(Math.max(0, timeout));
    }

    public static void revalidateDocuments(IProject project) {
        HashSet scheduled = new HashSet();
        textBufferDocuments.forEach((doc, job) -> {
            IResource resource = GherkinEditorDocumentManager.resourceForDocument(doc);
            if (resource == null || resource.getProject() != project) {
                return;
            }
            if (INSTANCE.addToBatch((IDocument)doc)) {
                return;
            }
            DocumentValidator.scheduleValidation(resource, job);
        });
        resourceDocuments.forEach((resource, job) -> {
            if (resource.getProject() == project && scheduled.add(resource)) {
                if (INSTANCE.addToBatch((IResource)resource)) {
                    return;
                }
                DocumentValidator.scheduleValidation(resource, job);
            }
        });
    }

    public static void shutdown() {
        textBufferDocuments.values().forEach(Job::cancel);
        textBufferDocuments.clear();
        resourceDocuments.values().forEach(Job::cancel);
        resourceDocuments.clear();
    }

    private synchronized void performBatchUpdate() {
        BatchUpdater updater = this.batch;
        if (updater == null) {
            return;
        }
        --updater.references;
        updater.checkForCancel();
        if (updater.references <= 0) {
            this.batch = null;
            if (updater.documents.isEmpty() && updater.resources.isEmpty()) {
                return;
            }
            if (updater.documents.size() + updater.resources.size() == 1) {
                for (IDocument doc : updater.documents) {
                    DocumentValidator.validate(doc, 0);
                }
                for (IResource resource : updater.resources) {
                    DocumentValidator.validate(resource, 0);
                }
                return;
            }
            BatchVerificationJob job = new BatchVerificationJob(updater);
            final BatchUpdater nextBatch = this.getBatch(job);
            job.addJobChangeListener(new IJobChangeListener(){

                public void sleeping(IJobChangeEvent event) {
                }

                public void scheduled(IJobChangeEvent event) {
                }

                public void running(IJobChangeEvent event) {
                }

                public void done(IJobChangeEvent event) {
                    nextBatch.close();
                }

                public void awake(IJobChangeEvent event) {
                }

                public void aboutToRun(IJobChangeEvent event) {
                }
            });
            job.schedule();
        }
    }

    private synchronized boolean addToBatch(IDocument document) {
        if (this.batch != null) {
            this.batch.documents.add(document);
            return true;
        }
        return false;
    }

    private synchronized boolean addToBatch(IResource resource) {
        if (this.batch != null) {
            this.batch.resources.add(resource);
            return true;
        }
        return false;
    }

    public static BatchUpdater batch() {
        return INSTANCE.getBatch(null);
    }

    private synchronized BatchUpdater getBatch(BatchVerificationJob job) {
        if (this.batch == null) {
            this.batch = new BatchUpdater(job){

                @Override
                public void close() {
                    DocumentValidator.this.performBatchUpdate();
                }
            };
            return this.batch;
        }
        ++this.batch.references;
        return this.batch;
    }

    public static void joinValidation(IProject project) throws InterruptedException, OperationCanceledException {
        Job[] jobs;
        if (project == null) {
            return;
        }
        Job[] jobArray = jobs = Job.getJobManager().find(IGlueValidator.class);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            VerificationJob verificationJob;
            Job job = jobArray[n2];
            if (job instanceof VerificationJob && (verificationJob = (VerificationJob)job).matches(project)) {
                job.join();
            }
            ++n2;
        }
    }
}

