/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.validation;

import io.cucumber.eclipse.editor.CucumberServiceRegistry;
import io.cucumber.eclipse.editor.EditorLogging;
import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.editor.marker.MarkerFactory;
import io.cucumber.eclipse.editor.validation.IGlueValidator;
import io.cucumber.messages.types.ParseError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

abstract class VerificationJob
extends Job {
    VerificationJob(String name) {
        super("Verify " + name);
    }

    public boolean belongsTo(Object family) {
        return family == VerificationJob.class || family == IGlueValidator.class;
    }

    protected IStatus run(IProgressMonitor monitor) {
        Collection<GherkinEditorDocument> editorDocuments = this.getEditorDocuments();
        monitor.subTask("Validate " + editorDocuments.size() + " Documents");
        if (editorDocuments.isEmpty()) {
            return Status.OK_STATUS;
        }
        List<GherkinEditorDocument> validDocuments = this.validateSyntax(editorDocuments, monitor);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.validateGlue(validDocuments, monitor);
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    private List<GherkinEditorDocument> validateSyntax(Collection<GherkinEditorDocument> editorDocuments, IProgressMonitor monitor) {
        ArrayList<GherkinEditorDocument> validDocuments = new ArrayList<GherkinEditorDocument>();
        for (GherkinEditorDocument editorDocument : editorDocuments) {
            if (monitor.isCanceled()) break;
            IResource resource = editorDocument.getResource();
            if (resource == null) continue;
            List<ParseError> syntaxErrors = editorDocument.getParseError().collect(Collectors.toList());
            MarkerFactory.syntaxErrorOnGherkin(resource, syntaxErrors, false);
            if (!syntaxErrors.isEmpty()) continue;
            validDocuments.add(editorDocument);
        }
        return validDocuments;
    }

    private void validateGlue(List<GherkinEditorDocument> validDocuments, IProgressMonitor monitor) {
        if (validDocuments.isEmpty()) {
            return;
        }
        LinkedHashMap<IGlueValidator, List> validatorToDocuments = new LinkedHashMap<IGlueValidator, List>();
        for (GherkinEditorDocument gherkinEditorDocument : validDocuments) {
            if (monitor.isCanceled()) break;
            IResource resource = gherkinEditorDocument.getResource();
            if (resource == null) continue;
            try {
                for (IGlueValidator validator : CucumberServiceRegistry.getGlueValidators(resource)) {
                    validatorToDocuments.computeIfAbsent(validator, k -> new ArrayList()).add(gherkinEditorDocument);
                }
            }
            catch (Exception e) {
                EditorLogging.error("Error determining validators for resource: " + String.valueOf(resource.getFullPath()), e);
            }
        }
        for (Map.Entry entry : validatorToDocuments.entrySet()) {
            if (monitor.isCanceled()) break;
            IGlueValidator validator = (IGlueValidator)entry.getKey();
            List documents = (List)entry.getValue();
            try {
                validator.validate(documents, monitor);
            }
            catch (Exception e) {
                EditorLogging.error("Error during glue validation with " + validator.getClass().getName(), e);
            }
        }
    }

    protected abstract Collection<GherkinEditorDocument> getEditorDocuments();

    public abstract boolean matches(IProject var1);
}

