/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.RecordComponent;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationHolder;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterNonNullDefaultProvider;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.util.Util;

public class MethodBinding
extends Binding {
    public int modifiers;
    public char[] selector;
    public TypeBinding returnType;
    public TypeBinding[] parameters;
    public TypeBinding receiver;
    public ReferenceBinding[] thrownExceptions;
    public ReferenceBinding declaringClass;
    public TypeVariableBinding[] typeVariables = Binding.NO_TYPE_VARIABLES;
    char[] signature;
    public IBinaryAnnotation binaryPreviewAnnotation;
    protected AnnotationBinding[] typeAnnotations = Binding.NO_ANNOTATIONS;
    public int defaultNullness;
    public byte[] parameterFlowBits;
    public static byte PARAM_NONNULL = 1;
    public static byte PARAM_NULLABLE = (byte)2;
    public static byte PARAM_NULLITY = (byte)(PARAM_NONNULL | PARAM_NULLABLE);
    public static byte PARAM_OWNING = (byte)4;
    public static byte PARAM_NOTOWNING = (byte)8;
    public static byte PARAM_MISSING_OWNING_ANN = (byte)16;
    public char[][] parameterNames = Binding.NO_PARAMETER_NAMES;

    public static byte flowBitFromAnnotationTagBit(long tagBit) {
        if (tagBit == 0x100000000000000L) {
            return PARAM_NONNULL;
        }
        if (tagBit == 0x80000000000000L) {
            return PARAM_NULLABLE;
        }
        if (tagBit == 0x200000000000000L) {
            return PARAM_OWNING;
        }
        if (tagBit == 0x400000000000000L) {
            return PARAM_NOTOWNING;
        }
        return 0;
    }

    protected MethodBinding() {
    }

    public MethodBinding(int modifiers, char[] selector, TypeBinding returnType, TypeBinding[] parameters, ReferenceBinding[] thrownExceptions, ReferenceBinding declaringClass) {
        this.modifiers = modifiers;
        this.selector = selector;
        this.returnType = returnType;
        this.parameters = parameters == null || parameters.length == 0 ? Binding.NO_PARAMETERS : parameters;
        this.thrownExceptions = thrownExceptions == null || thrownExceptions.length == 0 ? Binding.NO_EXCEPTIONS : thrownExceptions;
        this.declaringClass = declaringClass;
        if (this.declaringClass != null && this.declaringClass.isStrictfp() && !this.isNative() && !this.isAbstract()) {
            this.modifiers |= 0x800;
        }
    }

    public MethodBinding(int modifiers, TypeBinding[] parameters, ReferenceBinding[] thrownExceptions, ReferenceBinding declaringClass) {
        this(modifiers, TypeConstants.INIT, TypeBinding.VOID, parameters, thrownExceptions, declaringClass);
    }

    public MethodBinding(MethodBinding initialMethodBinding, ReferenceBinding declaringClass) {
        this.modifiers = initialMethodBinding.modifiers;
        this.selector = initialMethodBinding.selector;
        this.returnType = initialMethodBinding.returnType;
        this.parameters = initialMethodBinding.parameters;
        this.thrownExceptions = initialMethodBinding.thrownExceptions;
        this.declaringClass = declaringClass;
        declaringClass.storeAnnotationHolder(this, initialMethodBinding.declaringClass.retrieveAnnotationHolder(initialMethodBinding, true));
    }

    public final boolean areParameterErasuresEqual(MethodBinding method) {
        TypeBinding[] args = method.parameters;
        if (this.parameters == args) {
            return true;
        }
        int length = this.parameters.length;
        if (length != args.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (TypeBinding.notEquals(this.parameters[i], args[i]) && TypeBinding.notEquals(this.parameters[i].erasure(), args[i].erasure())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final boolean areParametersCompatibleWith(TypeBinding[] arguments) {
        int argLength;
        int paramLength = this.parameters.length;
        int lastIndex = argLength = arguments.length;
        if (this.isVarargs()) {
            lastIndex = paramLength - 1;
            if (paramLength == argLength) {
                varArgType = this.parameters[lastIndex];
                TypeBinding lastArgument = arguments[lastIndex];
                if (TypeBinding.notEquals(varArgType, lastArgument) && !lastArgument.isCompatibleWith(varArgType)) {
                    return false;
                }
            } else if (paramLength < argLength) {
                varArgType = ((ArrayBinding)this.parameters[lastIndex]).elementsType();
                int i = lastIndex;
                while (i < argLength) {
                    if (TypeBinding.notEquals(varArgType, arguments[i]) && !arguments[i].isCompatibleWith(varArgType)) {
                        return false;
                    }
                    ++i;
                }
            } else if (lastIndex != argLength) {
                return false;
            }
        }
        int i = 0;
        while (i < lastIndex) {
            if (TypeBinding.notEquals(this.parameters[i], arguments[i]) && !arguments[i].isCompatibleWith(this.parameters[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final boolean areParametersEqual(MethodBinding method) {
        TypeBinding[] args = method.parameters;
        if (this.parameters == args) {
            return true;
        }
        int length = this.parameters.length;
        if (length != args.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (TypeBinding.notEquals(this.parameters[i], args[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final boolean areTypeVariableErasuresEqual(MethodBinding method) {
        TypeVariableBinding[] vars = method.typeVariables;
        if (this.typeVariables == vars) {
            return true;
        }
        int length = this.typeVariables.length;
        if (length != vars.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (TypeBinding.notEquals(this.typeVariables[i], vars[i]) && TypeBinding.notEquals(this.typeVariables[i].erasure(), vars[i].erasure())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public MethodBinding asRawMethod(LookupEnvironment env) {
        if (this.typeVariables == Binding.NO_TYPE_VARIABLES) {
            return this;
        }
        int length = this.typeVariables.length;
        TypeBinding[] arguments = new TypeBinding[length];
        int i = 0;
        while (i < length) {
            arguments[i] = this.makeRawArgument(env, this.typeVariables[i]);
            ++i;
        }
        return env.createParameterizedGenericMethod(this, arguments);
    }

    private TypeBinding makeRawArgument(LookupEnvironment env, TypeVariableBinding var) {
        if (var.boundsCount() <= 1) {
            TypeBinding upperBound = var.upperBound();
            if (upperBound.isTypeVariable()) {
                return this.makeRawArgument(env, (TypeVariableBinding)upperBound);
            }
            return env.convertToRawType(upperBound, false);
        }
        ReferenceBinding[] itsSuperinterfaces = var.superInterfaces();
        int superLength = itsSuperinterfaces.length;
        TypeBinding rawFirstBound = null;
        TypeBinding[] rawOtherBounds = null;
        if (var.boundsCount() == superLength) {
            rawFirstBound = env.convertToRawType(itsSuperinterfaces[0], false);
            rawOtherBounds = new TypeBinding[superLength - 1];
            int s = 1;
            while (s < superLength) {
                rawOtherBounds[s - 1] = env.convertToRawType(itsSuperinterfaces[s], false);
                ++s;
            }
        } else {
            rawFirstBound = env.convertToRawType(var.superclass(), false);
            rawOtherBounds = new TypeBinding[superLength];
            int s = 0;
            while (s < superLength) {
                rawOtherBounds[s] = env.convertToRawType(itsSuperinterfaces[s], false);
                ++s;
            }
        }
        return env.createWildcard(null, 0, rawFirstBound, rawOtherBounds, 1);
    }

    public final boolean canBeSeenBy(InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding invocationType = scope.enclosingSourceType();
        if (TypeBinding.equalsEquals(invocationType, this.declaringClass)) {
            return true;
        }
        if (this.isProtected()) {
            if (invocationType.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            return invocationSite.isSuperAccess();
        }
        if (this.isPrivate()) {
            ReferenceBinding outerInvocationType = invocationType;
            ReferenceBinding temp = outerInvocationType.enclosingType();
            while (temp != null) {
                outerInvocationType = temp;
                temp = temp.enclosingType();
            }
            ReferenceBinding outerDeclaringClass = (ReferenceBinding)this.declaringClass.erasure();
            temp = outerDeclaringClass.enclosingType();
            while (temp != null) {
                outerDeclaringClass = temp;
                temp = temp.enclosingType();
            }
            return TypeBinding.equalsEquals(outerInvocationType, outerDeclaringClass);
        }
        return invocationType.fPackage == this.declaringClass.fPackage;
    }

    public final boolean canBeSeenBy(PackageBinding invocationPackage) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return invocationPackage == this.declaringClass.getPackage();
    }

    public final boolean canBeSeenBy(TypeBinding receiverType, InvocationSite invocationSite, Scope scope) {
        SourceTypeBinding invocationType = scope.enclosingSourceType();
        if (this.declaringClass.isInterface() && this.isStatic() && !this.isPrivate()) {
            return (invocationSite.isTypeAccess() || invocationSite.receiverIsImplicitThis()) && TypeBinding.equalsEquals(receiverType, this.declaringClass);
        }
        if (this.isPublic()) {
            return true;
        }
        if (TypeBinding.equalsEquals(invocationType, this.declaringClass) && TypeBinding.equalsEquals(invocationType, receiverType)) {
            return true;
        }
        if (invocationType == null) {
            return !this.isPrivate() && scope.getCurrentPackage() == this.declaringClass.fPackage;
        }
        if (this.isProtected()) {
            if (TypeBinding.equalsEquals(invocationType, this.declaringClass)) {
                return true;
            }
            if (invocationType.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            ReferenceBinding currentType = invocationType;
            TypeBinding receiverErasure = receiverType.erasure();
            ReferenceBinding declaringErasure = (ReferenceBinding)this.declaringClass.erasure();
            int depth = 0;
            do {
                if (currentType.findSuperTypeOriginatingFrom(declaringErasure) != null) {
                    if (invocationSite.isSuperAccess()) {
                        return true;
                    }
                    if (receiverType instanceof ArrayBinding) {
                        return false;
                    }
                    if (this.isStatic()) {
                        if (depth > 0) {
                            invocationSite.setDepth(depth);
                        }
                        return true;
                    }
                    if (TypeBinding.equalsEquals(currentType, receiverErasure) || receiverErasure.findSuperTypeOriginatingFrom(currentType) != null) {
                        if (depth > 0) {
                            invocationSite.setDepth(depth);
                        }
                        return true;
                    }
                }
                ++depth;
            } while ((currentType = currentType.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            if (TypeBinding.notEquals(receiverType, this.declaringClass)) {
                return false;
            }
            if (TypeBinding.notEquals(invocationType, this.declaringClass)) {
                ReferenceBinding outerInvocationType = invocationType;
                ReferenceBinding temp = outerInvocationType.enclosingType();
                while (temp != null) {
                    outerInvocationType = temp;
                    temp = temp.enclosingType();
                }
                ReferenceBinding outerDeclaringClass = (ReferenceBinding)this.declaringClass.erasure();
                temp = outerDeclaringClass.enclosingType();
                while (temp != null) {
                    outerDeclaringClass = temp;
                    temp = temp.enclosingType();
                }
                if (TypeBinding.notEquals(outerInvocationType, outerDeclaringClass)) {
                    return false;
                }
            }
            return true;
        }
        PackageBinding declaringPackage = this.declaringClass.fPackage;
        if (invocationType.fPackage != declaringPackage) {
            return false;
        }
        if (receiverType instanceof ArrayBinding) {
            return false;
        }
        TypeBinding originalDeclaringClass = this.declaringClass.original();
        ReferenceBinding currentType = (ReferenceBinding)receiverType;
        do {
            if (currentType.isCapture() ? TypeBinding.equalsEquals(originalDeclaringClass, currentType.erasure().original()) : TypeBinding.equalsEquals(originalDeclaringClass, currentType.original())) {
                return true;
            }
            PackageBinding currentPackage = currentType.fPackage;
            if (currentType.isCapture() || currentPackage == null || currentPackage == declaringPackage) continue;
            return false;
        } while ((currentType = currentType.superclass()) != null);
        return false;
    }

    public List<TypeBinding> collectMissingTypes(List<TypeBinding> missingTypes, boolean considerReturnType) {
        if ((this.tagBits & 0x80L) != 0L) {
            if (considerReturnType) {
                missingTypes = this.returnType.collectMissingTypes(missingTypes);
            }
            TypeBinding[] typeBindingArray = this.parameters;
            int n = this.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                TypeBinding parameter = typeBindingArray[n2];
                missingTypes = parameter.collectMissingTypes(missingTypes);
                ++n2;
            }
            typeBindingArray = this.thrownExceptions;
            n = this.thrownExceptions.length;
            n2 = 0;
            while (n2 < n) {
                TypeBinding thrownException = typeBindingArray[n2];
                missingTypes = thrownException.collectMissingTypes(missingTypes);
                ++n2;
            }
            typeBindingArray = this.typeVariables;
            n = this.typeVariables.length;
            n2 = 0;
            while (n2 < n) {
                ReferenceBinding[] interfaces;
                TypeBinding variable = typeBindingArray[n2];
                missingTypes = ((TypeVariableBinding)variable).superclass().collectMissingTypes(missingTypes);
                ReferenceBinding[] referenceBindingArray = interfaces = ((TypeVariableBinding)variable).superInterfaces();
                int n3 = interfaces.length;
                int n4 = 0;
                while (n4 < n3) {
                    ReferenceBinding binding = referenceBindingArray[n4];
                    missingTypes = binding.collectMissingTypes(missingTypes);
                    ++n4;
                }
                ++n2;
            }
        }
        return missingTypes;
    }

    public MethodBinding computeSubstitutedMethod(MethodBinding method, LookupEnvironment env) {
        int length = this.typeVariables.length;
        TypeVariableBinding[] vars = method.typeVariables;
        if (length != vars.length) {
            return null;
        }
        ParameterizedGenericMethodBinding substitute = env.createParameterizedGenericMethod(method, this.typeVariables);
        int i = 0;
        while (i < length) {
            if (!this.typeVariables[i].isInterchangeableWith(vars[i], substitute)) {
                return null;
            }
            ++i;
        }
        return substitute;
    }

    @Override
    public char[] computeUniqueKey(boolean isLeaf) {
        boolean addThrownExceptions;
        boolean isGeneric;
        char[] declaringKey = this.declaringClass.computeUniqueKey(false);
        int declaringLength = declaringKey.length;
        int selectorLength = this.selector == TypeConstants.INIT ? 0 : this.selector.length;
        char[] sig = this.genericSignature();
        boolean bl = isGeneric = sig != null;
        if (!isGeneric) {
            sig = this.signature();
        }
        int signatureLength = sig.length;
        int thrownExceptionsLength = this.thrownExceptions.length;
        int thrownExceptionsSignatureLength = 0;
        char[][] thrownExceptionsSignatures = null;
        boolean bl2 = addThrownExceptions = thrownExceptionsLength > 0 && (!isGeneric || CharOperation.lastIndexOf('^', sig) < 0);
        if (addThrownExceptions) {
            thrownExceptionsSignatures = new char[thrownExceptionsLength][];
            int i = 0;
            while (i < thrownExceptionsLength) {
                if (this.thrownExceptions[i] != null) {
                    thrownExceptionsSignatures[i] = this.thrownExceptions[i].signature();
                    thrownExceptionsSignatureLength += thrownExceptionsSignatures[i].length + 1;
                }
                ++i;
            }
        }
        char[] uniqueKey = new char[declaringLength + 1 + selectorLength + signatureLength + thrownExceptionsSignatureLength];
        int index = 0;
        System.arraycopy(declaringKey, 0, uniqueKey, index, declaringLength);
        index = declaringLength;
        uniqueKey[index++] = 46;
        System.arraycopy(this.selector, 0, uniqueKey, index, selectorLength);
        System.arraycopy(sig, 0, uniqueKey, index += selectorLength, signatureLength);
        if (thrownExceptionsSignatureLength > 0) {
            index += signatureLength;
            int i = 0;
            while (i < thrownExceptionsLength) {
                char[] thrownExceptionSignature = thrownExceptionsSignatures[i];
                if (thrownExceptionSignature != null) {
                    uniqueKey[index++] = 124;
                    int length = thrownExceptionSignature.length;
                    System.arraycopy(thrownExceptionSignature, 0, uniqueKey, index, length);
                    index += length;
                }
                ++i;
            }
        }
        return uniqueKey;
    }

    public final char[] constantPoolName() {
        return this.selector;
    }

    protected void fillInDefaultNonNullness(AbstractMethodDeclaration sourceMethod, boolean needToApplyReturnNonNullDefault, ParameterNonNullDefaultProvider needToApplyParameterNonNullDefault) {
        if (sourceMethod != null && sourceMethod.isCompactConstructor()) {
            return;
        }
        if (this.parameterFlowBits == null) {
            this.parameterFlowBits = new byte[this.parameters.length];
        }
        boolean added = false;
        int length = this.parameterFlowBits.length;
        int i = 0;
        while (i < length) {
            if (needToApplyParameterNonNullDefault.hasNonNullDefaultForParam(i) && !this.parameters[i].isBaseType()) {
                int nullity = this.parameterFlowBits[i] & PARAM_NULLITY;
                if (nullity == 0) {
                    added = true;
                    int n = i;
                    this.parameterFlowBits[n] = (byte)(this.parameterFlowBits[n] | PARAM_NONNULL);
                    if (sourceMethod != null) {
                        sourceMethod.arguments[i].binding.tagBits |= 0x100000000000000L;
                    }
                } else if (sourceMethod != null && (this.parameterFlowBits[i] & PARAM_NONNULL) != 0) {
                    sourceMethod.scope.problemReporter().nullAnnotationIsRedundant(sourceMethod, i);
                }
            }
            ++i;
        }
        if (added) {
            this.tagBits |= 0x400L;
        }
        if (!needToApplyReturnNonNullDefault) {
            return;
        }
        if (this.returnType != null && !this.returnType.isBaseType() && (this.tagBits & 0x180000000000000L) == 0L) {
            this.tagBits |= 0x100000000000000L;
        } else if (sourceMethod != null && (this.tagBits & 0x100000000000000L) != 0L) {
            sourceMethod.scope.problemReporter().nullAnnotationIsRedundant(sourceMethod, -1);
        }
    }

    protected void fillInDefaultNonNullness18(AbstractMethodDeclaration sourceMethod, LookupEnvironment env) {
        MethodBinding original = this.original();
        if (original == null) {
            return;
        }
        if (sourceMethod != null && sourceMethod.isCompactConstructor()) {
            return;
        }
        ParameterNonNullDefaultProvider hasNonNullDefaultForParameter = this.hasNonNullDefaultForParameter(sourceMethod);
        if (hasNonNullDefaultForParameter.hasAnyNonNullDefault()) {
            boolean added = false;
            int length = this.parameters.length;
            int i = 0;
            while (i < length) {
                if (hasNonNullDefaultForParameter.hasNonNullDefaultForParam(i)) {
                    long existing;
                    TypeBinding parameter = this.parameters[i];
                    if (original.parameters[i].acceptsNonNullDefault() && (existing = parameter.tagBits & 0x180000000000000L) == 0L) {
                        added = true;
                        if (!parameter.isBaseType()) {
                            this.parameters[i] = env.createNonNullAnnotatedType(parameter);
                            if (sourceMethod != null) {
                                sourceMethod.arguments[i].binding.type = this.parameters[i];
                            }
                        }
                    }
                }
                ++i;
            }
            if (added) {
                this.tagBits |= 0x400L;
            }
        }
        if (original.returnType != null && this.hasNonNullDefaultForReturnType(sourceMethod) && original.returnType.acceptsNonNullDefault()) {
            if ((this.returnType.tagBits & 0x180000000000000L) == 0L) {
                this.returnType = env.createAnnotatedType(this.returnType, new AnnotationBinding[]{env.getNonNullAnnotation()});
            } else if (sourceMethod instanceof MethodDeclaration && (this.returnType.tagBits & 0x100000000000000L) != 0L && ((MethodDeclaration)sourceMethod).hasNullTypeAnnotation(TypeReference.AnnotationPosition.MAIN_TYPE)) {
                sourceMethod.scope.problemReporter().nullAnnotationIsRedundant(sourceMethod, -1);
            }
        }
    }

    public MethodBinding findOriginalInheritedMethod(MethodBinding inheritedMethod) {
        MethodBinding inheritedOriginal = inheritedMethod.original();
        TypeBinding superType = this.declaringClass.findSuperTypeOriginatingFrom(inheritedOriginal.declaringClass);
        if (superType == null || !(superType instanceof ReferenceBinding)) {
            return null;
        }
        if (TypeBinding.notEquals(inheritedOriginal.declaringClass, superType)) {
            MethodBinding[] superMethods;
            MethodBinding[] methodBindingArray = superMethods = ((ReferenceBinding)superType).getMethods(inheritedOriginal.selector, inheritedOriginal.parameters.length);
            int n = superMethods.length;
            int n2 = 0;
            while (n2 < n) {
                MethodBinding superMethod = methodBindingArray[n2];
                if (superMethod.original() == inheritedOriginal) {
                    return superMethod;
                }
                ++n2;
            }
        }
        return inheritedOriginal;
    }

    public char[] genericSignature() {
        int n;
        int n2;
        TypeBinding[] typeBindingArray;
        if ((this.modifiers & 0x40000000) == 0) {
            return null;
        }
        StringBuilder sig = new StringBuilder(10);
        if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            sig.append('<');
            typeBindingArray = this.typeVariables;
            n2 = this.typeVariables.length;
            n = 0;
            while (n < n2) {
                TypeBinding typeVariable = typeBindingArray[n];
                sig.append(((TypeVariableBinding)typeVariable).genericSignature());
                ++n;
            }
            sig.append('>');
        }
        sig.append('(');
        typeBindingArray = this.parameters;
        n2 = this.parameters.length;
        n = 0;
        while (n < n2) {
            TypeBinding parameter = typeBindingArray[n];
            sig.append(parameter.genericTypeSignature());
            ++n;
        }
        sig.append(')');
        if (this.returnType != null) {
            sig.append(this.returnType.genericTypeSignature());
        }
        boolean needExceptionSignatures = false;
        int length = this.thrownExceptions.length;
        int i = 0;
        while (i < length) {
            if ((this.thrownExceptions[i].modifiers & 0x40000000) != 0) {
                needExceptionSignatures = true;
                break;
            }
            ++i;
        }
        if (needExceptionSignatures) {
            i = 0;
            while (i < length) {
                sig.append('^');
                sig.append(this.thrownExceptions[i].genericTypeSignature());
                ++i;
            }
        }
        int sigLength = sig.length();
        char[] genericSignature = new char[sigLength];
        sig.getChars(0, sigLength, genericSignature, 0);
        return genericSignature;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0x1FFFF;
    }

    @Override
    public AnnotationBinding[] getAnnotations() {
        MethodBinding originalMethod = this.original();
        return originalMethod.declaringClass.retrieveAnnotations(originalMethod);
    }

    @Override
    public long getAnnotationTagBits() {
        ClassScope scope;
        MethodBinding originalMethod = this.original();
        if ((originalMethod.extendedTagBits & 0x20) == 0 && originalMethod.declaringClass instanceof SourceTypeBinding && (scope = ((SourceTypeBinding)originalMethod.declaringClass).scope) != null) {
            Binding target;
            long nullDefaultBits;
            TypeDeclaration typeDecl = scope.referenceContext;
            AbstractMethodDeclaration methodDecl = typeDecl.declarationOf(originalMethod);
            if (methodDecl != null) {
                ASTNode.resolveAnnotations((BlockScope)methodDecl.scope, methodDecl.annotations, originalMethod);
            }
            CompilerOptions options = scope.compilerOptions();
            if (options.isAnnotationBasedNullAnalysisEnabled && (nullDefaultBits = (long)this.defaultNullness) != 0L && this.declaringClass instanceof SourceTypeBinding && (target = scope.checkRedundantDefaultNullness(this.defaultNullness, typeDecl.declarationSourceStart)) != null) {
                methodDecl.scope.problemReporter().nullDefaultAnnotationIsRedundant(methodDecl, methodDecl.annotations, target);
            }
        }
        return originalMethod.tagBits;
    }

    public Object getDefaultValue() {
        AnnotationHolder holder;
        MethodBinding originalMethod = this.original();
        if ((originalMethod.tagBits & 0x800000000000000L) == 0L) {
            if (originalMethod.declaringClass instanceof SourceTypeBinding) {
                AbstractMethodDeclaration methodDeclaration;
                SourceTypeBinding sourceType = (SourceTypeBinding)originalMethod.declaringClass;
                if (sourceType.scope != null && (methodDeclaration = originalMethod.sourceMethod()) != null && methodDeclaration.isAnnotationMethod()) {
                    methodDeclaration.resolve(sourceType.scope);
                }
            }
            originalMethod.tagBits |= 0x800000000000000L;
        }
        return (holder = originalMethod.declaringClass.retrieveAnnotationHolder(originalMethod, true)) == null ? null : holder.getDefaultValue();
    }

    public AnnotationBinding[][] getParameterAnnotations() {
        AnnotationBinding[][] allParameterAnnotations;
        int length = this.parameters.length;
        if (length == 0) {
            return null;
        }
        MethodBinding originalMethod = this.original();
        AnnotationHolder holder = originalMethod.declaringClass.retrieveAnnotationHolder(originalMethod, true);
        AnnotationBinding[][] annotationBindingArray = allParameterAnnotations = holder == null ? null : holder.getParameterAnnotations();
        if (allParameterAnnotations == null && (this.tagBits & 0x400L) != 0L) {
            allParameterAnnotations = new AnnotationBinding[length][];
            if (this.declaringClass instanceof SourceTypeBinding) {
                SourceTypeBinding sourceType = (SourceTypeBinding)this.declaringClass;
                if (sourceType.scope != null) {
                    AbstractMethodDeclaration methodDecl = sourceType.scope.referenceType().declarationOf(originalMethod);
                    int i = 0;
                    while (i < length) {
                        Argument argument = methodDecl.arguments[i];
                        if (argument.annotations != null) {
                            ASTNode.resolveAnnotations((BlockScope)methodDecl.scope, argument.annotations, argument.binding);
                            allParameterAnnotations[i] = argument.binding.getAnnotations();
                        } else {
                            allParameterAnnotations[i] = Binding.NO_ANNOTATIONS;
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < length) {
                        allParameterAnnotations[i] = Binding.NO_ANNOTATIONS;
                        ++i;
                    }
                }
            } else {
                int i = 0;
                while (i < length) {
                    allParameterAnnotations[i] = Binding.NO_ANNOTATIONS;
                    ++i;
                }
            }
            this.setParameterAnnotations(allParameterAnnotations);
        }
        return allParameterAnnotations;
    }

    public TypeVariableBinding getTypeVariable(char[] variableName) {
        int i = this.typeVariables.length;
        while (--i >= 0) {
            if (!CharOperation.equals(this.typeVariables[i].sourceName, variableName)) continue;
            return this.typeVariables[i];
        }
        return null;
    }

    public TypeVariableBinding[] getAllTypeVariables(boolean isDiamond) {
        TypeVariableBinding[] allTypeVariables = this.typeVariables;
        if (isDiamond) {
            TypeVariableBinding[] classTypeVariables = this.declaringClass.typeVariables();
            int l1 = allTypeVariables.length;
            int l2 = classTypeVariables.length;
            if (l1 == 0) {
                allTypeVariables = classTypeVariables;
            } else if (l2 != 0) {
                TypeVariableBinding[] typeVariableBindingArray = allTypeVariables;
                allTypeVariables = new TypeVariableBinding[l1 + l2];
                System.arraycopy(typeVariableBindingArray, 0, allTypeVariables, 0, l1);
                System.arraycopy(classTypeVariables, 0, allTypeVariables, l1, l2);
            }
        }
        return allTypeVariables;
    }

    public boolean hasSubstitutedParameters() {
        return false;
    }

    public boolean hasSubstitutedReturnType() {
        return false;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public final boolean isBridge() {
        return (this.modifiers & 0x40) != 0;
    }

    public final boolean isConstructor() {
        return this.selector == TypeConstants.INIT;
    }

    public final boolean isCanonicalConstructor() {
        return (this.extendedTagBits & 8) != 0;
    }

    public final boolean isCompactConstructor() {
        return (this.modifiers & 0x800000) != 0;
    }

    public final boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public final boolean isDefaultAbstract() {
        return (this.modifiers & 0x80000) != 0;
    }

    public boolean isDefaultMethod() {
        return (this.modifiers & 0x10000) != 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public final boolean isViewedAsDeprecated() {
        return this.isDeprecated();
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public final boolean isImplementing() {
        return (this.modifiers & 0x20000000) != 0;
    }

    public final boolean isMain() {
        TypeBinding paramType;
        return this.selector.length == 4 && CharOperation.equals(this.selector, TypeConstants.MAIN) && (this.modifiers & 9) != 0 && TypeBinding.VOID == this.returnType && this.parameters.length == 1 && (paramType = this.parameters[0]).dimensions() == 1 && paramType.leafComponentType().id == 11;
    }

    public final boolean isCandindateMain() {
        if (this.parameters.length > 1) {
            return false;
        }
        if (this.selector.length == 4 && CharOperation.equals(this.selector, TypeConstants.MAIN) && (this.modifiers & 2) == 0 && TypeBinding.VOID == this.returnType) {
            TypeBinding paramType;
            if (this.parameters.length == 0) {
                return true;
            }
            if (this.parameters.length == 1 && (paramType = this.parameters[0]).dimensions() == 1 && paramType.leafComponentType().id == 11) {
                return true;
            }
        }
        return false;
    }

    public final boolean isNative() {
        return (this.modifiers & 0x100) != 0;
    }

    public final boolean isOverriding() {
        return (this.modifiers & 0x10000000) != 0;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isOrEnclosedByPrivateType() {
        if ((this.modifiers & 2) != 0) {
            return true;
        }
        return this.declaringClass != null && this.declaringClass.isOrEnclosedByPrivateType();
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isStrictfp() {
        return (this.modifiers & 0x800) != 0;
    }

    public final boolean isSynchronized() {
        return (this.modifiers & 0x20) != 0;
    }

    public final boolean isSynthetic() {
        return (this.modifiers & 0x1000) != 0;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public boolean isVarargs() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isParameterizedGeneric() {
        return false;
    }

    public boolean isPolymorphic() {
        return false;
    }

    @Override
    public final int kind() {
        return 8;
    }

    public MethodBinding original() {
        return this;
    }

    public MethodBinding shallowOriginal() {
        return this.original();
    }

    public MethodBinding genericMethod() {
        return this;
    }

    @Override
    public char[] readableName() {
        StringBuilder buffer = new StringBuilder(this.parameters.length + 20);
        if (this.isConstructor()) {
            buffer.append(this.declaringClass.sourceName());
        } else {
            buffer.append(this.selector);
        }
        buffer.append('(');
        if (this.parameters != Binding.NO_PARAMETERS) {
            int i = 0;
            int length = this.parameters.length;
            while (i < length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.parameters[i].sourceName());
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString().toCharArray();
    }

    public final AnnotationBinding[] getTypeAnnotations() {
        return this.typeAnnotations;
    }

    public void setTypeAnnotations(AnnotationBinding[] annotations) {
        this.typeAnnotations = annotations;
    }

    @Override
    public void setAnnotations(AnnotationBinding[] annotations, boolean forceStore) {
        this.declaringClass.storeAnnotations(this, annotations, forceStore);
    }

    public void setAnnotations(AnnotationBinding[] annotations, AnnotationBinding[][] parameterAnnotations, Object defaultValue, LookupEnvironment optionalEnv) {
        this.declaringClass.storeAnnotationHolder(this, AnnotationHolder.storeAnnotations(annotations, parameterAnnotations, defaultValue, optionalEnv));
    }

    public void setDefaultValue(Object defaultValue) {
        MethodBinding originalMethod = this.original();
        originalMethod.tagBits |= 0x800000000000000L;
        AnnotationHolder holder = this.declaringClass.retrieveAnnotationHolder(this, false);
        if (holder == null) {
            this.setAnnotations(null, null, defaultValue, null);
        } else {
            this.setAnnotations(holder.getAnnotations(), holder.getParameterAnnotations(), defaultValue, null);
        }
    }

    public void setParameterAnnotations(AnnotationBinding[][] parameterAnnotations) {
        AnnotationHolder holder = this.declaringClass.retrieveAnnotationHolder(this, false);
        if (holder == null) {
            this.setAnnotations(null, parameterAnnotations, null, null);
        } else {
            this.setAnnotations(holder.getAnnotations(), parameterAnnotations, holder.getDefaultValue(), null);
        }
    }

    protected final void setSelector(char[] selector) {
        this.selector = selector;
        this.signature = null;
    }

    @Override
    public char[] shortReadableName() {
        StringBuilder buffer = new StringBuilder(this.parameters.length + 20);
        if (this.isConstructor()) {
            buffer.append(this.declaringClass.shortReadableName());
        } else {
            buffer.append(this.selector);
        }
        buffer.append('(');
        if (this.parameters != Binding.NO_PARAMETERS) {
            int i = 0;
            int length = this.parameters.length;
            while (i < length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.parameters[i].shortReadableName());
                ++i;
            }
        }
        buffer.append(')');
        int nameLength = buffer.length();
        char[] shortReadableName = new char[nameLength];
        buffer.getChars(0, nameLength, shortReadableName, 0);
        return shortReadableName;
    }

    public final char[] signature() {
        if (this.signature != null) {
            return this.signature;
        }
        return this.computeSignature(null);
    }

    public final char[] computeSignature(ClassFile classFile) {
        int n;
        boolean needSynthetics;
        StringBuilder buffer = new StringBuilder((this.parameters.length + 1) * 20);
        buffer.append('(');
        TypeBinding[] targetParameters = this.parameters;
        boolean isConstructor = this.isConstructor();
        if (isConstructor && this.declaringClass.isEnum()) {
            buffer.append(ConstantPool.JavaLangStringSignature);
            buffer.append(TypeBinding.INT.signature());
        }
        boolean bl = needSynthetics = isConstructor && this.declaringClass.isNestedType() && !this.declaringClass.isStatic();
        if (needSynthetics) {
            ReferenceBinding[] syntheticArgumentTypes = this.declaringClass.syntheticEnclosingInstanceTypes();
            if (syntheticArgumentTypes != null) {
                ReferenceBinding[] referenceBindingArray = syntheticArgumentTypes;
                int n2 = syntheticArgumentTypes.length;
                n = 0;
                while (n < n2) {
                    ReferenceBinding syntheticArgumentType = referenceBindingArray[n];
                    if ((syntheticArgumentType.tagBits & 0x800L) != 0L) {
                        this.tagBits |= 0x800L;
                        if (classFile != null) {
                            Util.recordNestedType(classFile, syntheticArgumentType);
                        }
                    }
                    buffer.append(syntheticArgumentType.signature());
                    ++n;
                }
            }
            if (this instanceof SyntheticMethodBinding) {
                targetParameters = ((SyntheticMethodBinding)this).targetMethod.parameters;
            }
        }
        if (targetParameters != Binding.NO_PARAMETERS) {
            TypeBinding[] typeBindingArray = targetParameters;
            n = targetParameters.length;
            int syntheticArgumentType = 0;
            while (syntheticArgumentType < n) {
                TypeBinding targetParameter = typeBindingArray[syntheticArgumentType];
                TypeBinding leafTargetParameterType = targetParameter.leafComponentType();
                if ((leafTargetParameterType.tagBits & 0x800L) != 0L) {
                    this.tagBits |= 0x800L;
                    if (classFile != null) {
                        Util.recordNestedType(classFile, leafTargetParameterType);
                    }
                }
                buffer.append(targetParameter.signature());
                ++syntheticArgumentType;
            }
        }
        if (needSynthetics) {
            SyntheticArgumentBinding[] syntheticOuterArguments = this.declaringClass.syntheticOuterLocalVariables();
            int count = syntheticOuterArguments == null ? 0 : syntheticOuterArguments.length;
            int i = 0;
            while (i < count) {
                buffer.append(syntheticOuterArguments[i].type.signature());
                ++i;
            }
            i = targetParameters.length;
            int extraLength = this.parameters.length;
            while (i < extraLength) {
                TypeBinding parameter = this.parameters[i];
                TypeBinding leafParameterType = parameter.leafComponentType();
                if ((leafParameterType.tagBits & 0x800L) != 0L) {
                    this.tagBits |= 0x800L;
                    if (classFile != null) {
                        Util.recordNestedType(classFile, leafParameterType);
                    }
                }
                buffer.append(parameter.signature());
                ++i;
            }
        }
        buffer.append(')');
        if (this.returnType != null) {
            TypeBinding ret = this.returnType.leafComponentType();
            if ((ret.tagBits & 0x800L) != 0L) {
                this.tagBits |= 0x800L;
                if (classFile != null) {
                    Util.recordNestedType(classFile, ret);
                }
            }
            buffer.append(this.returnType.signature());
        }
        int nameLength = buffer.length();
        this.signature = new char[nameLength];
        buffer.getChars(0, nameLength, this.signature, 0);
        return this.signature;
    }

    public char[] signature(ClassFile classFile) {
        if (this.signature != null) {
            if ((this.tagBits & 0x800L) != 0L) {
                int n;
                boolean needSynthetics;
                boolean isConstructor = this.isConstructor();
                TypeBinding[] targetParameters = this.parameters;
                boolean bl = needSynthetics = isConstructor && this.declaringClass.isNestedType() && !this.declaringClass.isStatic();
                if (needSynthetics) {
                    ReferenceBinding[] syntheticArgumentTypes = this.declaringClass.syntheticEnclosingInstanceTypes();
                    if (syntheticArgumentTypes != null) {
                        ReferenceBinding[] referenceBindingArray = syntheticArgumentTypes;
                        int n2 = syntheticArgumentTypes.length;
                        n = 0;
                        while (n < n2) {
                            ReferenceBinding syntheticArgumentType = referenceBindingArray[n];
                            if ((syntheticArgumentType.tagBits & 0x800L) != 0L) {
                                Util.recordNestedType(classFile, syntheticArgumentType);
                            }
                            ++n;
                        }
                    }
                    if (this instanceof SyntheticMethodBinding) {
                        targetParameters = ((SyntheticMethodBinding)this).targetMethod.parameters;
                    }
                }
                if (targetParameters != Binding.NO_PARAMETERS) {
                    TypeBinding[] typeBindingArray = targetParameters;
                    n = targetParameters.length;
                    int syntheticArgumentType = 0;
                    while (syntheticArgumentType < n) {
                        TypeBinding targetParameter = typeBindingArray[syntheticArgumentType];
                        TypeBinding leafTargetParameterType = targetParameter.leafComponentType();
                        if ((leafTargetParameterType.tagBits & 0x800L) != 0L) {
                            Util.recordNestedType(classFile, leafTargetParameterType);
                        }
                        ++syntheticArgumentType;
                    }
                }
                if (needSynthetics) {
                    int i = targetParameters.length;
                    int extraLength = this.parameters.length;
                    while (i < extraLength) {
                        TypeBinding parameter = this.parameters[i];
                        TypeBinding leafParameterType = parameter.leafComponentType();
                        if ((leafParameterType.tagBits & 0x800L) != 0L) {
                            Util.recordNestedType(classFile, leafParameterType);
                        }
                        ++i;
                    }
                }
                if (this.returnType != null) {
                    TypeBinding ret = this.returnType.leafComponentType();
                    if ((ret.tagBits & 0x800L) != 0L) {
                        Util.recordNestedType(classFile, ret);
                    }
                }
            }
            return this.signature;
        }
        return this.computeSignature(classFile);
    }

    public final int sourceEnd() {
        AbstractMethodDeclaration method = this.sourceMethod();
        if (method == null) {
            if (this.declaringClass instanceof SourceTypeBinding) {
                return ((SourceTypeBinding)this.declaringClass).sourceEnd();
            }
            return 0;
        }
        return method.sourceEnd;
    }

    /*
     * WARNING - void declaration
     */
    public AbstractMethodDeclaration sourceMethod() {
        void sourceType;
        AbstractMethodDeclaration[] methods;
        if (this.isSynthetic()) {
            return null;
        }
        ReferenceBinding referenceBinding = this.declaringClass;
        if (!(referenceBinding instanceof SourceTypeBinding)) {
            return null;
        }
        SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)referenceBinding;
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = methods = sourceType.scope != null ? sourceType.scope.referenceContext.methods : null;
        if (methods != null) {
            int i = methods.length;
            while (--i >= 0) {
                if (this != methods[i].binding) continue;
                return methods[i];
            }
        }
        return null;
    }

    public LambdaExpression sourceLambda() {
        return null;
    }

    public RecordComponent sourceRecordComponent() {
        return null;
    }

    public final int sourceStart() {
        AbstractMethodDeclaration method = this.sourceMethod();
        if (method == null) {
            if (this.declaringClass instanceof SourceTypeBinding) {
                return ((SourceTypeBinding)this.declaringClass).sourceStart();
            }
            return 0;
        }
        return method.sourceStart;
    }

    public String toString() {
        int length;
        int i;
        StringBuilder output = new StringBuilder(10);
        if ((this.modifiers & 0x2000000) != 0) {
            output.append("[unresolved] ");
        }
        ASTNode.printModifiers(this.modifiers, output);
        output.append(this.returnType != null ? this.returnType.debugName() : "<no type>");
        output.append(" ");
        output.append(this.selector != null ? new String(this.selector) : "<no selector>");
        output.append("(");
        if (this.parameters != null) {
            if (this.parameters != Binding.NO_PARAMETERS) {
                i = 0;
                length = this.parameters.length;
                while (i < length) {
                    if (i > 0) {
                        output.append(", ");
                    }
                    output.append(this.parameters[i] != null ? this.parameters[i].debugName() : "<no argument type>");
                    ++i;
                }
            }
        } else {
            output.append("<no argument types>");
        }
        output.append(") ");
        if (this.thrownExceptions != null) {
            if (this.thrownExceptions != Binding.NO_EXCEPTIONS) {
                output.append("throws ");
                i = 0;
                length = this.thrownExceptions.length;
                while (i < length) {
                    if (i > 0) {
                        output.append(", ");
                    }
                    output.append(this.thrownExceptions[i] != null ? this.thrownExceptions[i].debugName() : "<no exception type>");
                    ++i;
                }
            }
        } else {
            output.append("<no exception types>");
        }
        return output.toString();
    }

    public TypeVariableBinding[] typeVariables() {
        return this.typeVariables;
    }

    public boolean hasNonNullDefaultForReturnType(AbstractMethodDeclaration srcMethod) {
        return this.hasNonNullDefaultForType(this.returnType, 16, srcMethod, srcMethod == null ? -1 : srcMethod.declarationSourceStart);
    }

    static int getNonNullByDefaultValue(AnnotationBinding annotation) {
        ElementValuePair[] elementValuePairs = annotation.getElementValuePairs();
        if (elementValuePairs == null || elementValuePairs.length == 0) {
            ReferenceBinding annotationType = annotation.getAnnotationType();
            if (annotationType == null) {
                return 0;
            }
            MethodBinding[] annotationMethods = annotationType.methods();
            if (annotationMethods != null && annotationMethods.length == 1) {
                Object value = annotationMethods[0].getDefaultValue();
                return Annotation.nullLocationBitsFromAnnotationValue(value);
            }
            return 1080;
        }
        if (elementValuePairs.length > 0) {
            int nullness = 0;
            ElementValuePair[] elementValuePairArray = elementValuePairs;
            int n = elementValuePairs.length;
            int n2 = 0;
            while (n2 < n) {
                ElementValuePair elementValuePair = elementValuePairArray[n2];
                nullness |= Annotation.nullLocationBitsFromAnnotationValue(elementValuePair.getValue());
                ++n2;
            }
            return nullness;
        }
        return 2;
    }

    public ParameterNonNullDefaultProvider hasNonNullDefaultForParameter(AbstractMethodDeclaration srcMethod) {
        int len = this.parameters.length;
        boolean[] result = new boolean[len];
        boolean trueFound = false;
        boolean falseFound = false;
        int i = 0;
        while (i < len) {
            boolean b;
            AnnotationBinding[][] parameterAnnotations;
            int nonNullByDefaultValue;
            int start = srcMethod == null || srcMethod.arguments == null || srcMethod.arguments.length == 0 ? -1 : srcMethod.arguments[i].declarationSourceStart;
            int n = nonNullByDefaultValue = srcMethod != null && start >= 0 ? srcMethod.scope.localNonNullByDefaultValue(start) : 0;
            if (nonNullByDefaultValue == 0 && (parameterAnnotations = this.getParameterAnnotations()) != null) {
                AnnotationBinding[] annotationBindings;
                AnnotationBinding[] annotationBindingArray = annotationBindings = parameterAnnotations[i];
                int n2 = annotationBindings.length;
                int n3 = 0;
                while (n3 < n2) {
                    AnnotationBinding annotationBinding = annotationBindingArray[n3];
                    ReferenceBinding annotationType = annotationBinding.getAnnotationType();
                    if (annotationType.hasNullBit(128)) {
                        nonNullByDefaultValue |= MethodBinding.getNonNullByDefaultValue(annotationBinding);
                    }
                    ++n3;
                }
            }
            if (b = nonNullByDefaultValue != 0 ? (nonNullByDefaultValue & 8) != 0 : this.hasNonNullDefaultForType(this.parameters[i], 8, srcMethod, start)) {
                trueFound = true;
            } else {
                falseFound = true;
            }
            result[i] = b;
            ++i;
        }
        if (trueFound && falseFound) {
            return new ParameterNonNullDefaultProvider.MixedProvider(result);
        }
        return trueFound ? ParameterNonNullDefaultProvider.TRUE_PROVIDER : ParameterNonNullDefaultProvider.FALSE_PROVIDER;
    }

    protected boolean hasNonNullDefaultForType(TypeBinding type, int location, AbstractMethodDeclaration srcMethod, int start) {
        if (type != null && !type.acceptsNonNullDefault() && srcMethod != null && srcMethod.scope.environment().usesNullTypeAnnotations()) {
            return false;
        }
        if ((this.modifiers & 0x4000000) != 0) {
            return false;
        }
        if (this.defaultNullness != 0) {
            return (this.defaultNullness & location) != 0;
        }
        return this.declaringClass.hasNonNullDefaultForType(null, location, start);
    }

    public boolean redeclaresPublicObjectMethod(Scope scope) {
        if (this.selector[0] == 'h') {
            return this.parameters.length == 0 && this.selector.length == 8 && CharOperation.equals(this.selector, TypeConstants.HASHCODE);
        }
        if (this.selector[0] == 't') {
            return this.parameters.length == 0 && this.selector.length == 8 && CharOperation.equals(this.selector, TypeConstants.TOSTRING);
        }
        return this.selector[0] == 'e' && this.parameters.length == 1 && this.selector.length == 6 && CharOperation.equals(this.selector, TypeConstants.EQUALS) && TypeBinding.equalsEquals(this.parameters[0], scope.getJavaLangObject());
    }

    public boolean isVoidMethod() {
        return this.returnType == TypeBinding.VOID;
    }

    public boolean doesParameterLengthMatch(int suggestedParameterLength) {
        int len = this.parameters.length;
        return len <= suggestedParameterLength || this.isVarargs() && len == suggestedParameterLength + 1;
    }

    public void updateTypeVariableBinding(TypeVariableBinding previousBinding, TypeVariableBinding updatedBinding) {
        TypeVariableBinding[] bindings = this.typeVariables;
        if (bindings != null) {
            int i = 0;
            while (i < bindings.length) {
                if (bindings[i] == previousBinding) {
                    bindings[i] = updatedBinding;
                }
                ++i;
            }
        }
    }

    public boolean hasPolymorphicSignature(Scope scope) {
        ReferenceBinding declaringClassLocal;
        if ((this.tagBits & 0x10000000000000L) != 0L) {
            return true;
        }
        return this.isNative() && this.isVarargs() && this.parameters.length == 1 && this.parameters[0].leafComponentType().id == 1 && (declaringClassLocal = this.declaringClass) != null && (declaringClassLocal.id == scope.getJavaLangInvokeMethodHandle().id || declaringClassLocal.id == scope.getJavaLangInvokeVarHandle().id);
    }

    public boolean isClosingMethod() {
        boolean isCloseMethod = CharOperation.equals(this.selector, TypeConstants.CLOSE) && this.parameters == NO_PARAMETERS;
        if (isCloseMethod |= (this.extendedTagBits & 1) != 0) {
            return this.declaringClass.hasTypeBit(1);
        }
        return false;
    }

    public boolean ownsParameter(int i) {
        if (this.parameterFlowBits != null) {
            return (this.parameterFlowBits[i] & PARAM_OWNING) != 0;
        }
        if (i == 0 && this.parameters.length > 0 && this.declaringClass.hasTypeBit(4)) {
            return this.parameters[0].hasTypeBit(1);
        }
        return false;
    }

    public boolean notownsParameter(int i) {
        if (this.parameterFlowBits != null) {
            return (this.parameterFlowBits[i] & PARAM_NOTOWNING) != 0;
        }
        return false;
    }

    public boolean parameterHasMissingOwningAnnotation(int rank) {
        if (this.parameterFlowBits != null) {
            return (this.parameterFlowBits[rank] & PARAM_MISSING_OWNING_ANN) != 0;
        }
        return false;
    }

    public void markMissingOwningAnnotationOnParameter(int rank) {
        if (this.parameterFlowBits == null) {
            this.parameterFlowBits = new byte[this.parameters.length];
        }
        int n = rank;
        this.parameterFlowBits[n] = (byte)(this.parameterFlowBits[n] | PARAM_MISSING_OWNING_ANN);
    }

    public Boolean getParameterNullness(int idx) {
        if (this.parameterFlowBits != null) {
            int nullity = this.parameterFlowBits[idx] & PARAM_NULLITY;
            if (nullity == PARAM_NONNULL) {
                return Boolean.TRUE;
            }
            if (nullity == PARAM_NULLABLE) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public void verifyOverrideCompatibility(MethodBinding inheritedMethod, ClassScope scope) {
        int len = Math.min(this.parameters.length, inheritedMethod.parameters.length);
        AbstractMethodDeclaration sourceMethod = this.sourceMethod();
        int i = 0;
        while (i < len) {
            if (inheritedMethod.ownsParameter(i) && !this.ownsParameter(i)) {
                scope.problemReporter().overrideReducingParamterOwning(sourceMethod.arguments[i]);
            }
            ++i;
        }
        if ((this.tagBits & 0x200000000000000L) != 0L && (inheritedMethod.tagBits & 0x200000000000000L) == 0L) {
            scope.problemReporter().overrideAddingReturnOwning(sourceMethod);
        }
    }

    public boolean isWellknownMethod(char[][] compoundClassName, char[] wellKnownSelector) {
        return CharOperation.equals(this.declaringClass.compoundName, compoundClassName) && CharOperation.equals(this.selector, wellKnownSelector);
    }

    public boolean isWellknownMethod(int typeId, char[] wellKnownSelector) {
        return this.declaringClass.id == typeId && CharOperation.equals(this.selector, wellKnownSelector);
    }

    public boolean isAsVisible(ReferenceBinding declaringType) {
        if (declaringType.modifiers == this.modifiers || this.isPublic() || declaringType.isPrivate()) {
            return true;
        }
        if (declaringType.isPublic()) {
            return false;
        }
        if (this.isProtected()) {
            return true;
        }
        if (declaringType.isProtected()) {
            return false;
        }
        return !this.isPrivate();
    }
}

