/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.folder.handlers;

import com.kms.katalon.application.utils.EntityTrackingHelper;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.constants.ComposerComponentsImplMessageConstants;
import com.kms.katalon.composer.components.impl.transfer.TreeEntityTransfer;
import com.kms.katalon.composer.components.impl.tree.ApiCollectionTreeEntity;
import com.kms.katalon.composer.components.impl.tree.CheckpointTreeEntity;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.impl.tree.ProfileTreeEntity;
import com.kms.katalon.composer.components.impl.tree.SystemFileTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteCollectionTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WindowsElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityProcessingUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.transfer.TransferMoveFlag;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.folder.constants.StringConstants;
import com.kms.katalon.controller.CheckpointController;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.SystemFileController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.controller.TestSuiteCollectionController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.controller.WindowsElementController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.folder.ApiCollectionEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testobject.events.TestObjectUpdatedEvent;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.jdt.internal.ui.refactoring.reorg.NewNameQueries;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class PasteFolderHandler {
    @Inject
    IEventBroker eventBroker;
    @Inject
    MApplication application;
    @Inject
    EModelService modelService;
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;
    @Named(value="activeShell")
    Shell parentShell;
    private ITreeEntity lastPastedTreeEntity;
    private ITreeEntity parentPastedTreeEntity;

    @PostConstruct
    private void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/PASTE_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                block13: {
                    try {
                        Clipboard clipboard;
                        ITreeEntity[] treeEntities;
                        Object targetObject = event.getProperty("org.eclipse.e4.data");
                        if (targetObject == null) break block13;
                        ITreeEntity targetTreeEntity = null;
                        FolderEntity targetFolder = null;
                        if (targetObject instanceof FolderTreeEntity) {
                            targetFolder = ((FolderTreeEntity)targetObject).getObject();
                            targetTreeEntity = (ITreeEntity)targetObject;
                        } else if (targetObject instanceof ITreeEntity && ((ITreeEntity)targetObject).getParent() instanceof FolderTreeEntity) {
                            targetFolder = ((FolderTreeEntity)((ITreeEntity)targetObject).getParent()).getObject();
                            targetTreeEntity = ((ITreeEntity)targetObject).getParent();
                        }
                        if (targetFolder == null) break block13;
                        if (targetFolder.getFolderType() == FolderEntity.FolderType.TESTSUITE && !PasteFolderHandler.this.featureController.isQuotaUnlimited(ProductFeature.TEST_SUITE_CREATIONS_LIMIT)) {
                            ProjectEntity currentProject = targetFolder.getProject();
                            try {
                                List tsList = TestSuiteController.getInstance().getAllTestSuites(currentProject);
                                if (PasteFolderHandler.this.featureController.isLimitReached(ProductFeature.TEST_SUITE_CREATIONS_LIMIT, tsList.size())) {
                                    String dialogTitle = ComposerComponentsImplMessageConstants.DIA_KSE_FEATURE_RESTRICT_UNLIMITED_TEST_SUITE_CREATIONS;
                                    String dialogMessage = ComposerComponentsImplMessageConstants.MSG_KSE_FEATURE_RESTRICT_UNLIMITED_TEST_SUITE_CREATIONS;
                                    PasteFolderHandler.this.productFeatureDialog.showNotAvailableFeature(ProductFeature.TEST_SUITE_CREATIONS_LIMIT, dialogTitle, dialogMessage);
                                    return;
                                }
                            }
                            catch (Exception e) {
                                LoggerSingleton.logError((Throwable)e);
                                return;
                            }
                        }
                        if (PasteFolderHandler.this.verifyPaste(treeEntities = (ITreeEntity[])(clipboard = new Clipboard(Display.getCurrent())).getContents((Transfer)TreeEntityTransfer.getInstance()), targetFolder)) {
                            PasteFolderHandler.this.parentPastedTreeEntity = targetTreeEntity;
                            PasteFolderHandler.this.lastPastedTreeEntity = null;
                            if (TransferMoveFlag.isMove()) {
                                PasteFolderHandler.this.move(treeEntities, targetFolder);
                                ITreeEntity[] iTreeEntityArray = treeEntities;
                                int n = treeEntities.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    ITreeEntity treeEntity = iTreeEntityArray[n2];
                                    PasteFolderHandler.this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)treeEntity.getParent());
                                    ++n2;
                                }
                            } else {
                                PasteFolderHandler.this.copy(treeEntities, targetFolder);
                            }
                            PasteFolderHandler.this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)targetTreeEntity);
                            PasteFolderHandler.this.eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)(PasteFolderHandler.this.lastPastedTreeEntity != null ? PasteFolderHandler.this.lastPastedTreeEntity : targetTreeEntity));
                        }
                    }
                    catch (Exception ex) {
                        LoggerSingleton.logError((Throwable)ex);
                        String message = ex instanceof FilePathTooLongException ? ex.getMessage() : StringConstants.HAND_ERROR_MSG_UNABLE_TO_PASTE_DATA;
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)message);
                    }
                }
            }
        });
    }

    private void copy(ITreeEntity[] treeEntities, FolderEntity targetFolder) throws Exception {
        try {
            ITreeEntity[] iTreeEntityArray = treeEntities;
            int n = treeEntities.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeEntity treeEntity = iTreeEntityArray[n2];
                if (treeEntity instanceof TestCaseTreeEntity && targetFolder.getFolderType() == FolderEntity.FolderType.TESTCASE) {
                    this.copyTestCase(((TestCaseTreeEntity)treeEntity).getObject(), targetFolder);
                } else if (treeEntity instanceof ApiCollectionTreeEntity && targetFolder.getFolderType() == FolderEntity.FolderType.WEBELEMENT) {
                    this.copyApiCollection(((ApiCollectionTreeEntity)treeEntity).getObject(), targetFolder);
                } else if (treeEntity instanceof FolderTreeEntity && targetFolder.getFolderType() == ((FolderTreeEntity)treeEntity).getObject().getFolderType()) {
                    this.copyFolder(((FolderTreeEntity)treeEntity).getObject(), targetFolder);
                } else if (treeEntity instanceof TestSuiteTreeEntity && targetFolder.getFolderType() == FolderEntity.FolderType.TESTSUITE) {
                    this.copyTestSuite(((TestSuiteTreeEntity)treeEntity).getObject(), targetFolder);
                } else if (treeEntity instanceof TestDataTreeEntity && targetFolder.getFolderType() == FolderEntity.FolderType.DATAFILE) {
                    this.copyTestData(((TestDataTreeEntity)treeEntity).getObject(), targetFolder);
                } else if (treeEntity instanceof WebElementTreeEntity && targetFolder.getFolderType() == FolderEntity.FolderType.WEBELEMENT) {
                    this.copyTestObject((WebElementEntity)((WebElementTreeEntity)treeEntity).getObject(), targetFolder);
                } else if (treeEntity instanceof PackageTreeEntity && targetFolder.getFolderType() == FolderEntity.FolderType.KEYWORD) {
                    this.copyKeywordPackage((IPackageFragment)((PackageTreeEntity)treeEntity).getObject(), targetFolder, null);
                } else if (treeEntity instanceof TestSuiteCollectionTreeEntity && targetFolder.getFolderType() == FolderEntity.FolderType.TESTSUITE) {
                    this.copyTestSuiteCollection((TestSuiteCollectionEntity)((TestSuiteCollectionTreeEntity)treeEntity).getObject(), targetFolder);
                } else if (treeEntity instanceof CheckpointTreeEntity && targetFolder.getFolderType() == FolderEntity.FolderType.CHECKPOINT) {
                    this.copyCheckpoint(((CheckpointTreeEntity)treeEntity).getObject(), targetFolder);
                } else if (treeEntity instanceof ProfileTreeEntity && targetFolder.getFolderType() == FolderEntity.FolderType.PROFILE) {
                    this.copyExecutionProfile((ProfileTreeEntity)treeEntity, targetFolder);
                } else if (treeEntity instanceof SystemFileTreeEntity && targetFolder.getFolderType() == FolderEntity.FolderType.INCLUDE) {
                    this.copySystemFileEntity((SystemFileTreeEntity)treeEntity, targetFolder);
                } else if (treeEntity instanceof WindowsElementTreeEntity && targetFolder.getFolderType() == FolderEntity.FolderType.WEBELEMENT) {
                    this.copyWindowsObject(((WindowsElementTreeEntity)treeEntity).getObject(), targetFolder);
                }
                ++n2;
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            return;
        }
    }

    private void move(ITreeEntity[] treeEntities, FolderEntity targetFolder) throws Exception {
        try {
            ITreeEntity[] iTreeEntityArray = treeEntities;
            int n = treeEntities.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeEntity treeEntity = iTreeEntityArray[n2];
                if (treeEntity.isRemoveable()) {
                    if (treeEntity instanceof TestCaseTreeEntity) {
                        this.moveTestCase(((TestCaseTreeEntity)treeEntity).getObject(), targetFolder);
                    } else if (treeEntity instanceof ApiCollectionTreeEntity) {
                        this.moveApiCollection(((ApiCollectionTreeEntity)treeEntity).getObject(), targetFolder);
                    } else if (treeEntity instanceof FolderTreeEntity) {
                        this.moveFolder(((FolderTreeEntity)treeEntity).getObject(), targetFolder);
                    } else if (treeEntity instanceof TestSuiteTreeEntity) {
                        this.moveTestSuite(((TestSuiteTreeEntity)treeEntity).getObject(), targetFolder);
                    } else if (treeEntity instanceof TestDataTreeEntity) {
                        this.moveTestData(((TestDataTreeEntity)treeEntity).getObject(), targetFolder);
                    } else if (treeEntity instanceof WebElementTreeEntity) {
                        this.moveTestObject((WebElementEntity)((WebElementTreeEntity)treeEntity).getObject(), targetFolder);
                    } else if (treeEntity instanceof PackageTreeEntity) {
                        this.moveKeywordPackage((IPackageFragment)((PackageTreeEntity)treeEntity).getObject(), targetFolder);
                    } else if (treeEntity instanceof TestSuiteCollectionTreeEntity) {
                        this.moveTestSuiteCollection((TestSuiteCollectionEntity)((TestSuiteCollectionTreeEntity)treeEntity).getObject(), targetFolder);
                    } else if (treeEntity instanceof CheckpointTreeEntity) {
                        this.moveCheckpoint(((CheckpointTreeEntity)treeEntity).getObject(), targetFolder);
                    } else if (treeEntity instanceof SystemFileTreeEntity) {
                        this.moveSystemFile(((SystemFileTreeEntity)treeEntity).getObject(), targetFolder);
                    } else if (treeEntity instanceof WindowsElementTreeEntity) {
                        this.moveWindowsObject(((WindowsElementTreeEntity)treeEntity).getObject(), targetFolder);
                    }
                }
                ++n2;
            }
            GroovyUtil.getGroovyProject((ProjectEntity)targetFolder.getProject()).refreshLocal(2, null);
        }
        catch (FilePathTooLongException e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
        }
        catch (OperationCanceledException operationCanceledException) {
            return;
        }
    }

    private boolean verifyPaste(ITreeEntity[] treeEntities, FolderEntity targetFolder) throws Exception {
        if (treeEntities == null) {
            return false;
        }
        ITreeEntity[] iTreeEntityArray = treeEntities;
        int n = treeEntities.length;
        int n2 = 0;
        while (n2 < n) {
            ApiCollectionEntity folder;
            ITreeEntity treeEntity = iTreeEntityArray[n2];
            if (treeEntity instanceof ApiCollectionTreeEntity && treeEntity.getObject() instanceof ApiCollectionEntity) {
                folder = (ApiCollectionEntity)treeEntity.getObject();
                if (folder.equals((Object)targetFolder)) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)MessageFormat.format(StringConstants.HAND_ERROR_MSG_UNABLE_TO_PASTE_SAME_SRC_DEST, folder.getName()));
                    return false;
                }
                if (targetFolder.getFolderType() != FolderEntity.FolderType.WEBELEMENT) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)"API Collections can only be pasted in Object Repository context");
                    return false;
                }
            } else if (treeEntity instanceof FolderTreeEntity && treeEntity.getObject() instanceof FolderEntity && (folder = (FolderEntity)treeEntity.getObject()).equals((Object)targetFolder)) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)MessageFormat.format(StringConstants.HAND_ERROR_MSG_UNABLE_TO_PASTE_SAME_SRC_DEST, folder.getName()));
                return false;
            }
            if (!treeEntity.getCopyTag().equals(targetFolder.getFolderType().toString())) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)MessageFormat.format(StringConstants.HAND_ERROR_MSG_CANNOT_PASTE_INTO_DIFF_REGION, treeEntity.getCopyTag(), targetFolder.getFolderType().toString()));
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void copyTestCase(TestCaseEntity testCase, FolderEntity targetFolder) throws Exception {
        TestCaseEntity copiedTestCase;
        if (testCase != null && (copiedTestCase = TestCaseController.getInstance().copyTestCase(testCase, targetFolder)) != null) {
            this.eventBroker.post("EXPLORER/COPY_PASTED_SELECTED_ITEM", (Object)new Object[]{testCase.getIdForDisplay(), copiedTestCase.getIdForDisplay()});
            this.lastPastedTreeEntity = new TestCaseTreeEntity(copiedTestCase, this.parentPastedTreeEntity);
            EntityTrackingHelper.trackTestCaseCreated();
        }
    }

    private void copyFolder(FolderEntity folder, FolderEntity targetFolder) throws Exception {
        FolderEntity copiedFolder = FolderController.getInstance().copyFolder(folder, targetFolder);
        if (copiedFolder != null) {
            this.eventBroker.post("EXPLORER/COPY_PASTED_SELECTED_ITEM", (Object)new Object[]{folder.getRelativePathForUI().replace('\\', '/') + "/", copiedFolder.getRelativePathForUI().replace('\\', '/') + "/"});
            this.lastPastedTreeEntity = new FolderTreeEntity(copiedFolder, this.parentPastedTreeEntity);
        }
    }

    private void copyTestSuite(TestSuiteEntity testSuite, FolderEntity targetFolder) throws Exception {
        TestSuiteEntity copiedTestSuite;
        if (testSuite != null && (copiedTestSuite = TestSuiteController.getInstance().copyTestSuite(testSuite, targetFolder)) != null) {
            this.eventBroker.post("EXPLORER/COPY_PASTED_SELECTED_ITEM", (Object)new Object[]{testSuite.getIdForDisplay(), copiedTestSuite.getIdForDisplay()});
            this.lastPastedTreeEntity = new TestSuiteTreeEntity(copiedTestSuite, this.parentPastedTreeEntity);
        }
    }

    private void copyTestData(DataFileEntity dataFile, FolderEntity targetFolder) throws Exception {
        DataFileEntity copiedDataFile;
        if (dataFile != null && (copiedDataFile = TestDataController.getInstance().copyDataFile(dataFile, targetFolder)) != null) {
            this.eventBroker.post("EXPLORER/COPY_PASTED_SELECTED_ITEM", (Object)new Object[]{dataFile.getIdForDisplay(), copiedDataFile.getIdForDisplay()});
            this.lastPastedTreeEntity = new TestDataTreeEntity(copiedDataFile, this.parentPastedTreeEntity);
        }
    }

    private void copyTestSuiteCollection(TestSuiteCollectionEntity testSuiteCollection, FolderEntity targetFolder) throws Exception {
        if (testSuiteCollection == null) {
            return;
        }
        TestSuiteCollectionEntity copiedTestSuiteCollection = TestSuiteCollectionController.getInstance().copyTestSuiteCollection(testSuiteCollection, targetFolder);
        if (copiedTestSuiteCollection != null) {
            this.eventBroker.post("EXPLORER/COPY_PASTED_SELECTED_ITEM", (Object)new Object[]{testSuiteCollection.getIdForDisplay(), copiedTestSuiteCollection.getIdForDisplay()});
            this.lastPastedTreeEntity = new TestSuiteCollectionTreeEntity(copiedTestSuiteCollection, (FolderTreeEntity)this.parentPastedTreeEntity);
        }
    }

    private void copyTestObject(WebElementEntity webElement, FolderEntity targetFolder) throws Exception {
        WebElementEntity copiedWebElement;
        if (webElement != null && (copiedWebElement = ObjectRepositoryController.getInstance().copyWebElement(webElement, targetFolder)) != null) {
            this.eventBroker.post("EXPLORER/COPY_PASTED_SELECTED_ITEM", (Object)new Object[]{webElement.getIdForDisplay(), copiedWebElement.getIdForDisplay()});
            this.lastPastedTreeEntity = new WebElementTreeEntity(copiedWebElement, this.parentPastedTreeEntity);
        }
    }

    private void copyKeywordPackage(IPackageFragment packageFragment, FolderEntity targetFolder, String newPackageName) throws Exception {
        block3: {
            try {
                String parentPath = packageFragment.getParent().getElementName() + "/";
                String packageName = packageFragment.getElementName();
                GroovyUtil.copyPackage((IPackageFragment)packageFragment, (FolderEntity)targetFolder, (String)newPackageName);
                if (newPackageName == null) {
                    newPackageName = packageName;
                }
                this.eventBroker.post("EXPLORER/COPY_PASTED_SELECTED_ITEM", (Object)new Object[]{parentPath + (packageName.isEmpty() ? StringConstants.DEFAULT_PACKAGE_NAME : packageName), parentPath + newPackageName});
            }
            catch (JavaModelException javaModelException) {
                if (javaModelException.getJavaModelStatus().getCode() != 977) break block3;
                NewNameQueries newNameQueries = new NewNameQueries(this.parentShell);
                INewNameQuery newNameQuery = newNameQueries.createNewPackageNameQuery(packageFragment, packageFragment.getElementName());
                this.copyKeywordPackage(packageFragment, targetFolder, newNameQuery.getNewName());
            }
        }
    }

    private void copyCheckpoint(CheckpointEntity checkpoint, FolderEntity targetFolder) throws DALException, FilePathTooLongException {
        if (checkpoint == null) {
            return;
        }
        CheckpointEntity copiedCheckpoint = CheckpointController.getInstance().copy(checkpoint, targetFolder);
        if (copiedCheckpoint != null) {
            this.eventBroker.post("EXPLORER/COPY_PASTED_SELECTED_ITEM", (Object)new Object[]{checkpoint.getIdForDisplay(), copiedCheckpoint.getIdForDisplay()});
            this.lastPastedTreeEntity = new CheckpointTreeEntity(copiedCheckpoint, this.parentPastedTreeEntity);
        }
    }

    private void copyExecutionProfile(ProfileTreeEntity profileTree, FolderEntity targetFolder) throws Exception {
        ExecutionProfileEntity sourceProfile = profileTree.getObject();
        ExecutionProfileEntity coppiedProfile = GlobalVariableController.getInstance().copyProfile(sourceProfile);
        this.eventBroker.post("EXECUTION_PROFILE/CREATED", (Object)coppiedProfile.getName());
        this.lastPastedTreeEntity = new ProfileTreeEntity(coppiedProfile, profileTree.getParent());
    }

    private void copySystemFileEntity(SystemFileTreeEntity treeEntity, FolderEntity targetFolder) throws Exception {
        SystemFileEntity coppiedSystemFile = SystemFileController.getInstance().copySystemFile(treeEntity.getObject(), targetFolder);
        this.lastPastedTreeEntity = new SystemFileTreeEntity(coppiedSystemFile, (ITreeEntity)((FolderTreeEntity)this.parentPastedTreeEntity));
    }

    private void moveTestCase(TestCaseEntity testCase, FolderEntity targetFolder) throws Exception {
        TestCaseEntity movedTestCase = EntityProcessingUtil.moveTestCase((TestCaseEntity)testCase, (FolderEntity)targetFolder);
        if (movedTestCase != null) {
            this.lastPastedTreeEntity = new TestCaseTreeEntity(movedTestCase, this.parentPastedTreeEntity);
        }
    }

    private void moveFolder(FolderEntity folder, FolderEntity targetFolder) throws Exception {
        if (folder instanceof ApiCollectionEntity) {
            this.moveApiCollection((ApiCollectionEntity)folder, targetFolder);
            return;
        }
        FolderEntity movedFolder = EntityProcessingUtil.moveFolder((FolderEntity)folder, (FolderEntity)targetFolder);
        if (movedFolder != null) {
            this.lastPastedTreeEntity = new FolderTreeEntity(movedFolder, this.parentPastedTreeEntity);
        }
    }

    private void moveTestSuite(TestSuiteEntity testSuite, FolderEntity targetFolder) throws Exception {
        TestSuiteEntity movedTestSuite = EntityProcessingUtil.moveTestSuite((TestSuiteEntity)testSuite, (FolderEntity)targetFolder);
        if (movedTestSuite != null) {
            this.lastPastedTreeEntity = new TestSuiteTreeEntity(movedTestSuite, this.parentPastedTreeEntity);
        }
    }

    private void moveTestData(DataFileEntity dataFile, FolderEntity targetFolder) throws Exception {
        DataFileEntity movedTestData = EntityProcessingUtil.moveTestData((DataFileEntity)dataFile, (FolderEntity)targetFolder);
        if (movedTestData != null) {
            this.lastPastedTreeEntity = new TestDataTreeEntity(movedTestData, this.parentPastedTreeEntity);
        }
    }

    private void moveTestObject(WebElementEntity webElement, FolderEntity targetFolder) throws Exception {
        WebElementEntity movedTestObject = EntityProcessingUtil.moveTestObject((WebElementEntity)webElement, (FolderEntity)targetFolder);
        if (movedTestObject != null) {
            this.lastPastedTreeEntity = new WebElementTreeEntity(movedTestObject, this.parentPastedTreeEntity);
        }
    }

    private void moveKeywordPackage(IPackageFragment packageFragment, FolderEntity targetFolder) {
    }

    private void moveTestSuiteCollection(TestSuiteCollectionEntity dataFile, FolderEntity targetFolder) throws Exception {
        TestSuiteCollectionEntity movedTestSuiteCollection = EntityProcessingUtil.moveTestSuiteCollection((TestSuiteCollectionEntity)dataFile, (FolderEntity)targetFolder);
        if (movedTestSuiteCollection != null) {
            this.lastPastedTreeEntity = new TestSuiteCollectionTreeEntity(movedTestSuiteCollection, (FolderTreeEntity)this.parentPastedTreeEntity);
        }
    }

    private void moveCheckpoint(CheckpointEntity checkpoint, FolderEntity targetFolder) throws Exception {
        CheckpointEntity movedCheckpoint = EntityProcessingUtil.moveCheckpoint((CheckpointEntity)checkpoint, (FolderEntity)targetFolder);
        if (movedCheckpoint != null) {
            this.lastPastedTreeEntity = new CheckpointTreeEntity(movedCheckpoint, this.parentPastedTreeEntity);
        }
    }

    private void moveSystemFile(SystemFileEntity systemFile, FolderEntity targetFolder) throws DALException {
        SystemFileEntity newSystemFile = SystemFileController.getInstance().moveSystemFile(systemFile, targetFolder);
        if (newSystemFile != null) {
            this.lastPastedTreeEntity = new SystemFileTreeEntity(newSystemFile, (ITreeEntity)((FolderTreeEntity)this.parentPastedTreeEntity));
        }
    }

    private void moveWindowsObject(WindowsElementEntity windowsElement, FolderEntity targetFolder) throws ControllerException, FilePathTooLongException {
        String oldId = windowsElement.getIdForDisplay();
        WindowsElementEntity newsWindowsElement = WindowsElementController.getInstance().moveWindowsElementEntity(windowsElement, targetFolder);
        if (newsWindowsElement != null) {
            this.lastPastedTreeEntity = new WindowsElementTreeEntity(newsWindowsElement, (FolderTreeEntity)this.parentPastedTreeEntity);
            EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/CUT_PASTED_SELECTED_ITEM", (Object)new Object[]{oldId, newsWindowsElement.getIdForDisplay()});
        }
    }

    private void copyWindowsObject(WindowsElementEntity object, FolderEntity targetFolder) throws ControllerException, FilePathTooLongException {
        WindowsElementEntity coppiedSystemFile = WindowsElementController.getInstance().copyWindowsElementEntity(object, targetFolder);
        this.lastPastedTreeEntity = new WindowsElementTreeEntity(coppiedSystemFile, (FolderTreeEntity)this.parentPastedTreeEntity);
    }

    private void copyApiCollection(ApiCollectionEntity sourceFolder, FolderEntity targetParentFolder) throws Exception {
        FolderEntity copiedFolder = FolderController.getInstance().copyFolder((FolderEntity)sourceFolder, targetParentFolder);
        this.handleApiCollectionOperation(copiedFolder, sourceFolder, false);
    }

    private void moveApiCollection(ApiCollectionEntity sourceFolder, FolderEntity targetParentFolder) throws Exception {
        String oldId = sourceFolder.getId();
        String oldIdForDisplay = sourceFolder.getIdForDisplay();
        FolderEntity movedFolder = FolderController.getInstance().moveFolder((FolderEntity)sourceFolder, targetParentFolder);
        ApiCollectionEntity resultFolder = this.handleApiCollectionOperation(movedFolder, sourceFolder, true);
        if (resultFolder != null) {
            this.eventBroker.post("EXPLORER/CUT_PASTED_SELECTED_ITEM", (Object)new Object[]{oldIdForDisplay, resultFolder.getIdForDisplay()});
            this.eventBroker.post("TESTOBJECT/UPDATED", (Object)new Object[]{oldId, resultFolder});
            this.postChildEndpointEvents((FolderEntity)resultFolder);
        }
    }

    private ApiCollectionEntity handleApiCollectionOperation(FolderEntity resultFolder, ApiCollectionEntity sourceFolder, boolean isMove) throws Exception {
        ApiCollectionEntity apiCollection;
        if (resultFolder == null) {
            return null;
        }
        if (resultFolder instanceof ApiCollectionEntity) {
            apiCollection = (ApiCollectionEntity)resultFolder;
        } else {
            apiCollection = this.convertToApiCollectionEntity(resultFolder, sourceFolder);
            FolderController.getInstance().saveFolder((FolderEntity)apiCollection);
        }
        this.lastPastedTreeEntity = new ApiCollectionTreeEntity(apiCollection, this.parentPastedTreeEntity);
        String eventType = isMove ? "EXPLORER/CUT_PASTED_SELECTED_ITEM" : "EXPLORER/COPY_PASTED_SELECTED_ITEM";
        this.eventBroker.post(eventType, (Object)new Object[]{sourceFolder.getRelativePathForUI().replace('\\', '/') + "/", apiCollection.getRelativePathForUI().replace('\\', '/') + "/"});
        return apiCollection;
    }

    private ApiCollectionEntity convertToApiCollectionEntity(FolderEntity folder, ApiCollectionEntity sourceFolder) {
        ApiCollectionEntity apiCollection = new ApiCollectionEntity();
        apiCollection.setName(folder.getName());
        apiCollection.setParentFolder(folder.getParentFolder());
        apiCollection.setProject(folder.getProject());
        apiCollection.setFolderType(folder.getFolderType());
        apiCollection.setCollectionType(sourceFolder.getCollectionType());
        if (sourceFolder.getAuthorization() != null) {
            apiCollection.setAuthorization(sourceFolder.getAuthorization());
        }
        return apiCollection;
    }

    private void postChildEndpointEvents(FolderEntity movedFolder) {
        try {
            List childEntities = FolderController.getInstance().getAllDescentdantEntities(movedFolder);
            for (Object child : childEntities) {
                if (child instanceof WebElementEntity) {
                    WebElementEntity webElement = (WebElementEntity)child;
                    this.eventBroker.post("TESTOBJECT/UPDATED", (Object)new TestObjectUpdatedEvent(webElement.getId(), (FileEntity)webElement, TestObjectUpdatedEvent.TriggeredBy.MOVE_TEST_OBJECT));
                    continue;
                }
                if (!(child instanceof ApiCollectionEntity)) continue;
                ApiCollectionEntity apiCollection = (ApiCollectionEntity)child;
                this.eventBroker.post("TESTOBJECT/UPDATED", (Object)new Object[]{apiCollection.getId(), apiCollection});
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

