/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.core.domain.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.onboarding.core.domain.model.BaseItem;
import com.kms.katalon.onboarding.core.domain.model.KnowledgeCategory;
import com.kms.katalon.onboarding.core.domain.model.KnowledgeItem;

public class KnowledgeHub {
    @JsonProperty(value="web")
    private KnowledgeCategory web;
    @JsonProperty(value="api")
    private KnowledgeCategory api;
    @JsonProperty(value="mobile")
    private KnowledgeCategory mobile;
    @JsonProperty(value="desktop")
    private KnowledgeCategory desktop;
    @JsonProperty(value="forYou")
    private KnowledgeCategory forYou;

    public KnowledgeCategory getWeb() {
        return this.web;
    }

    public void setWeb(KnowledgeCategory web) {
        this.web = web;
    }

    public KnowledgeCategory getApi() {
        return this.api;
    }

    public void setApi(KnowledgeCategory api) {
        this.api = api;
    }

    public KnowledgeCategory getMobile() {
        return this.mobile;
    }

    public void setMobile(KnowledgeCategory mobile) {
        this.mobile = mobile;
    }

    public KnowledgeCategory getDesktop() {
        return this.desktop;
    }

    public void setDesktop(KnowledgeCategory desktop) {
        this.desktop = desktop;
    }

    public KnowledgeCategory getForYou() {
        return this.forYou;
    }

    public void setForYou(KnowledgeCategory forYou) {
        this.forYou = forYou;
    }

    public BaseItem getItemById(String itemId) {
        BaseItem item;
        if (itemId == null || itemId.isEmpty()) {
            return null;
        }
        if (this.web != null && (item = this.findItemInCategory(this.web, itemId)) != null) {
            return item;
        }
        if (this.api != null && (item = this.findItemInCategory(this.api, itemId)) != null) {
            return item;
        }
        if (this.mobile != null && (item = this.findItemInCategory(this.mobile, itemId)) != null) {
            return item;
        }
        if (this.desktop != null && (item = this.findItemInCategory(this.desktop, itemId)) != null) {
            return item;
        }
        if (this.forYou != null && (item = this.findItemInCategory(this.forYou, itemId)) != null) {
            return item;
        }
        return null;
    }

    private BaseItem findItemInCategory(KnowledgeCategory category, String itemId) {
        if (category.getVideoDemos() != null) {
            for (KnowledgeItem knowledgeItem : category.getVideoDemos()) {
                if (!itemId.equals(knowledgeItem.getId())) continue;
                return knowledgeItem;
            }
        }
        if (category.getOnlineCourses() != null) {
            for (KnowledgeItem knowledgeItem : category.getOnlineCourses()) {
                if (!itemId.equals(knowledgeItem.getId())) continue;
                return knowledgeItem;
            }
        }
        if (category.getDocumentations() != null) {
            for (KnowledgeItem knowledgeItem : category.getDocumentations()) {
                if (!itemId.equals(knowledgeItem.getId())) continue;
                return knowledgeItem;
            }
        }
        if (category.getOnboardingTours() != null) {
            for (BaseItem baseItem : category.getOnboardingTours()) {
                if (!itemId.equals(baseItem.getId())) continue;
                return baseItem;
            }
        }
        return null;
    }

    public String toJson() {
        try {
            return KnowledgeHub.createObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jsonProcessingException) {
            return "{}";
        }
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        return mapper;
    }
}

