/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.configuration;

import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.webui.util.WebDriverPropertyUtil;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.webui.configuration.WebUiRunConfiguration;
import com.kms.katalon.execution.webui.driver.ChromeDriverConnector;
import com.kms.katalon.execution.webui.driver.WebDriverUpdateManager;
import com.kms.katalon.execution.webui.driver.WebUiDriverConnector;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ChromeRunConfiguration
extends WebUiRunConfiguration {
    protected String driverPath = WebDriverUpdateManager.getInstance().getChromeDriverPath();

    public ChromeRunConfiguration(String projectDir) throws IOException {
        this(projectDir, new ChromeDriverConnector(projectDir + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME));
    }

    public ChromeRunConfiguration(String projectDir, WebUiDriverConnector webUiDriverConnector) throws IOException {
        super(projectDir, webUiDriverConnector);
    }

    public IRunConfiguration cloneConfig() throws IOException {
        return new ChromeRunConfiguration(this.projectDir);
    }

    public boolean allowsRecording() {
        return true;
    }

    @Override
    public Map<String, IDriverConnector> getDriverConnectors() {
        Map<String, IDriverConnector> driverConnectors = super.getDriverConnectors();
        for (Map.Entry<String, IDriverConnector> entry : driverConnectors.entrySet()) {
            if (!(entry.getValue() instanceof ChromeDriverConnector)) continue;
            ChromeDriverConnector driverConnector = (ChromeDriverConnector)entry.getValue();
            driverConnector.setChromeDriverPath(this.driverPath);
        }
        return driverConnectors;
    }

    public Map<String, String> getAdditionalEnvironmentVariables() throws IOException, ExecutionException {
        HashMap<String, String> environmentVariables = new HashMap<String, String>(super.getAdditionalEnvironmentVariables());
        environmentVariables.put("KATALON_DOCKER", String.valueOf(WebDriverPropertyUtil.isRunningInDocker()));
        return environmentVariables;
    }
}

