/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.driver;

import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.execution.webui.configuration.WebDriverManagerRunConfiguration;
import com.kms.katalon.execution.webui.driver.SeleniumWebDriverProvider;
import com.kms.katalon.execution.webui.enums.BrowserType;
import com.kms.katalon.execution.webui.util.BrowserUtil;
import com.kms.katalon.execution.webui.util.ProcessUtil;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class WebDriverUpdateManager {
    private static final WebDriverUpdateManager INSTANCE = new WebDriverUpdateManager();
    private final ConcurrentHashMap<WebUIDriverType, ReentrantLock> driverLocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<WebUIDriverType, String> cachedDriverPaths = new ConcurrentHashMap();

    private WebDriverUpdateManager() {
    }

    public static WebDriverUpdateManager getInstance() {
        return INSTANCE;
    }

    private ReentrantLock getLockForDriver(WebUIDriverType driverType) {
        return this.driverLocks.computeIfAbsent(driverType, k -> new ReentrantLock());
    }

    private String getDriverPath(WebUIDriverType driverType) {
        ReentrantLock lock = this.getLockForDriver(driverType);
        if (this.cachedDriverPaths.containsKey(driverType)) {
            return this.cachedDriverPaths.get(driverType);
        }
        lock.lock();
        try {
            if (this.cachedDriverPaths.containsKey(driverType)) {
                String string = this.cachedDriverPaths.get(driverType);
                return string;
            }
            String driverPath = this.buildDriverPath(driverType);
            this.cachedDriverPaths.put(driverType, driverPath);
            String string = driverPath;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    private String buildDriverPath(WebUIDriverType driverType) {
        DriverConfig config = this.getDriverConfig(driverType);
        String driverPath = this.getInitialDriverPath(config);
        if (!this.isUpdateDriverAllowed()) {
            this.printDriverNotUpdatedMessage(driverPath, config.driverName);
            return driverPath;
        }
        return this.performDriverUpdate(driverPath, config);
    }

    private DriverConfig getDriverConfig(WebUIDriverType driverType) {
        switch (driverType) {
            case CHROME_DRIVER: {
                return new DriverConfig(driverType, BrowserType.CHROME, "Chrome", "chromedriver", true);
            }
            case EDGE_CHROMIUM_DRIVER: {
                return new DriverConfig(driverType, BrowserType.EDGE_CHROMIUM, "Edge Chromium", "Edge Chromium driver", true);
            }
            case FIREFOX_DRIVER: {
                return new DriverConfig(driverType, null, "Gecko", "Gecko driver", false);
            }
        }
        throw new IllegalArgumentException("Unsupported driver type: " + String.valueOf(driverType));
    }

    private String getInitialDriverPath(DriverConfig config) {
        try {
            switch (config.driverType) {
                case CHROME_DRIVER: {
                    return SeleniumWebDriverProvider.getChromeDriverPath();
                }
                case EDGE_CHROMIUM_DRIVER: {
                    return SeleniumWebDriverProvider.getEdgeChromiumDriverPath();
                }
                case FIREFOX_DRIVER: {
                    return SeleniumWebDriverProvider.getGeckoDriverPath();
                }
            }
            return "";
        }
        catch (IOException ex) {
            LogUtil.printAndLogError((Throwable)ex);
            return "";
        }
    }

    private String getTempDriverPath(DriverConfig config) {
        try {
            switch (config.driverType) {
                case CHROME_DRIVER: {
                    return SeleniumWebDriverProvider.getTempChromeDriverPath();
                }
                case EDGE_CHROMIUM_DRIVER: {
                    return SeleniumWebDriverProvider.getTempEdgeChromiumDriverPath();
                }
                case FIREFOX_DRIVER: {
                    return SeleniumWebDriverProvider.getTempGeckoDriverPath();
                }
            }
            return "";
        }
        catch (IOException ex) {
            LogUtil.logError((Throwable)ex);
            return "";
        }
    }

    private void terminateProcesses(DriverConfig config) {
        ProcessHandle currentProcess = ProcessHandle.current();
        switch (config.driverType) {
            case CHROME_DRIVER: {
                ProcessUtil.terminateChromeBrowsers(currentProcess);
                ProcessUtil.terminateChromeDrivers(currentProcess);
                break;
            }
            case EDGE_CHROMIUM_DRIVER: {
                ProcessUtil.terminateMsedgeBrowsers(currentProcess);
                ProcessUtil.terminateMsedgeDrivers(currentProcess);
                break;
            }
            case FIREFOX_DRIVER: {
                ProcessUtil.terminateFirefoxBrowsers(currentProcess);
                ProcessUtil.terminateGeckoDrivers(currentProcess);
            }
        }
    }

    private String performDriverUpdate(String driverPath, DriverConfig config) {
        String driverVersion;
        String updatedPath;
        String browserVersion;
        LogUtil.printOutputLine((String)"--------------------------------------------------------------------------------");
        String string = browserVersion = config.hasBrowserVersion ? BrowserUtil.getBrowserVersion(config.browserType) : null;
        if (config.hasBrowserVersion) {
            this.printBrowserVersion(browserVersion, config.browserName);
        }
        if ((updatedPath = this.checkTempDriver(driverPath, driverVersion = BrowserUtil.getWebDriverVersion(driverPath), config)) != null) {
            driverPath = updatedPath;
            driverVersion = BrowserUtil.getWebDriverVersion(driverPath);
        }
        if (driverVersion != null) {
            LogUtil.printOutputLine((String)(config.browserName + " driver version: " + driverVersion));
        }
        if (config.browserName.equals("Gecko")) {
            driverPath = this.handleGeckoDriverSpecialCase(driverPath, driverVersion, config);
        } else if (this.shouldDownloadDriver(browserVersion, driverVersion, config.hasBrowserVersion)) {
            driverPath = this.downloadDriver(driverPath, config);
        } else {
            LogUtil.printOutputLine((String)("Using existing " + config.browserName + " driver version. Skipping download of a new version."));
        }
        LogUtil.printOutputLine((String)(config.browserName + " driver is located at: " + driverPath));
        LogUtil.printOutputLine((String)"--------------------------------------------------------------------------------");
        return driverPath;
    }

    private void printBrowserVersion(String browserVersion, String browserName) {
        if (browserVersion != null) {
            LogUtil.printOutputLine((String)(browserName + " browser version: " + browserVersion));
        } else {
            LogUtil.logError((String)("Cannot detect " + browserName + " browser version."));
        }
    }

    private String checkTempDriver(String driverPath, String driverVersion, DriverConfig config) {
        String tempWebDriverPath = this.getTempDriverPath(config);
        if (tempWebDriverPath.isEmpty()) {
            return null;
        }
        if (new File(tempWebDriverPath).exists()) {
            int tempVersion;
            String tempDriverVersion = BrowserUtil.getWebDriverVersion(tempWebDriverPath);
            int currentVersion = config.hasBrowserVersion ? BrowserUtil.getMajorVersion(driverVersion) : BrowserUtil.getMinorVersion(driverVersion);
            int n = tempVersion = config.hasBrowserVersion ? BrowserUtil.getMajorVersion(tempDriverVersion) : BrowserUtil.getMinorVersion(tempDriverVersion);
            if (tempVersion > currentVersion) {
                return tempWebDriverPath;
            }
        }
        return null;
    }

    private String handleGeckoDriverSpecialCase(String driverPath, String driverVersion, DriverConfig config) {
        String latestDriver;
        if (driverVersion != null && (latestDriver = BrowserUtil.getLatestGeckodriverVersion()) != null && BrowserUtil.getMinorVersion(driverVersion) == BrowserUtil.getMinorVersion(latestDriver)) {
            LogUtil.printOutputLine((String)"The existing Gecko driver is up to date. Skipping download of a new version.");
            LogUtil.printOutputLine((String)("Gecko driver is located at: " + driverPath));
            LogUtil.printOutputLine((String)"--------------------------------------------------------------------------------");
            return driverPath;
        }
        return this.downloadDriver(driverPath, config);
    }

    private boolean shouldDownloadDriver(String browserVersion, String driverVersion, boolean hasBrowserVersion) {
        if (!hasBrowserVersion) {
            return false;
        }
        return browserVersion == null || driverVersion == null || BrowserUtil.getMajorVersion(browserVersion) != BrowserUtil.getMajorVersion(driverVersion);
    }

    private String downloadDriver(String driverPath, DriverConfig config) {
        WebDriverManagerRunConfiguration webDriverManagerRunConfiguration = new WebDriverManagerRunConfiguration();
        try {
            ProcessHandle currentProcess = ProcessHandle.current();
            ProcessUtil.dumpChildProcesses(currentProcess, 0);
            LogUtil.printOutputLine((String)("Terminate all " + config.browserName.toLowerCase() + " browser and driver processes" + (config.browserName.equals("Chrome") ? "." : "")));
            this.terminateProcesses(config);
            LogUtil.printOutputLine((String)("Start to download the " + config.browserName + " driver"));
            webDriverManagerRunConfiguration.downloadDriver(config.driverType, SeleniumWebDriverProvider.getTempDriverDirectory());
            String tempDriverPath = this.getTempDriverPath(config);
            if (!tempDriverPath.isEmpty() && new File(tempDriverPath).exists()) {
                driverPath = tempDriverPath;
                String driverVersion = BrowserUtil.getWebDriverVersion(driverPath);
                LogUtil.printOutputLine((String)("Updated " + config.browserName + " driver version: " + driverVersion));
            }
        }
        catch (IOException | InterruptedException e) {
            LogUtil.printOutputLine((String)("Download the " + config.browserName + " driver failed"));
            LogUtil.logError((Throwable)e);
        }
        return driverPath;
    }

    public String getChromeDriverPath() {
        return this.getDriverPath(WebUIDriverType.CHROME_DRIVER);
    }

    public String getEdgeChromiumDriverPath() {
        return this.getDriverPath(WebUIDriverType.EDGE_CHROMIUM_DRIVER);
    }

    public String getGeckoDriverPath() {
        return this.getDriverPath(WebUIDriverType.FIREFOX_DRIVER);
    }

    private boolean isUpdateDriverAllowed() {
        ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.core.webui");
        return store.getBoolean("webui.autoUpdateDrivers") && ApplicationRunningMode.get() == RunningMode.CONSOLE;
    }

    private void printDriverNotUpdatedMessage(String driverPath, String driverName) {
        LogUtil.printOutputLine((String)String.format("%s is located at default location: %s. In case your browser is updated to a newer version, please use this command to update driver: --config -%s=true", driverName, driverPath, "webui.autoUpdateDrivers"));
    }

    public void clearCache() {
        this.cachedDriverPaths.clear();
    }

    private static class DriverConfig {
        final WebUIDriverType driverType;
        final BrowserType browserType;
        final String browserName;
        final String driverName;
        final boolean hasBrowserVersion;

        DriverConfig(WebUIDriverType driverType, BrowserType browserType, String browserName, String driverName, boolean hasBrowserVersion) {
            this.driverType = driverType;
            this.browserType = browserType;
            this.browserName = browserName;
            this.driverName = driverName;
            this.hasBrowserVersion = hasBrowserVersion;
        }
    }
}

