/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.util;

import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ProcessUtil {
    public static void terminateChromeDrivers(ProcessHandle process) {
        if (OSUtil.isWindows()) {
            ProcessUtil.killChildProcesses(process, "chromedriver.exe");
        } else {
            ProcessUtil.killChildProcesses(process, "chromedriver");
        }
    }

    public static void terminateChromeBrowsers(ProcessHandle process) {
        if (OSUtil.isWindows()) {
            ProcessUtil.killChildProcesses(process, "chrome.exe");
        } else {
            ProcessUtil.killChildProcesses(process, "Google Chrome");
        }
    }

    public static void terminateMsedgeDrivers(ProcessHandle process) {
        if (OSUtil.isWindows()) {
            ProcessUtil.killChildProcesses(process, "msedgedriver.exe");
        } else {
            ProcessUtil.killChildProcesses(process, "msedgedriver");
        }
    }

    public static void terminateMsedgeBrowsers(ProcessHandle process) {
        if (OSUtil.isWindows()) {
            ProcessUtil.killChildProcesses(process, "msedge.exe");
        } else {
            ProcessUtil.killChildProcesses(process, "Microsoft Edge");
        }
    }

    public static void terminateGeckoDrivers(ProcessHandle process) {
        if (OSUtil.isWindows()) {
            ProcessUtil.killChildProcesses(process, "geckodriver.exe");
        } else {
            ProcessUtil.killChildProcesses(process, "geckodriver");
        }
    }

    public static void terminateFirefoxBrowsers(ProcessHandle process) {
        if (OSUtil.isWindows()) {
            ProcessUtil.killChildProcesses(process, "firefox.exe");
        } else {
            ProcessUtil.killChildProcesses(process, "Firefox");
        }
    }

    public static void killChildProcesses(ProcessHandle process, String ... processes) {
        List<String> processNames = Arrays.asList(processes).stream().map(p -> p.toLowerCase()).collect(Collectors.toList());
        ArrayList<ProcessHandle> toKillProcesses = new ArrayList<ProcessHandle>();
        ProcessUtil.collectChildProcesses(process, processNames, toKillProcesses);
        ProcessUtil.killProcesses(toKillProcesses);
    }

    private static void collectChildProcesses(ProcessHandle process, List<String> processNames, List<ProcessHandle> toKillProcesses) {
        process.children().forEach(child -> ProcessUtil.collectChildProcesses(child, processNames, toKillProcesses));
        Optional<String> command = process.info().command();
        String processName = ProcessUtil.extractProcessName(command);
        if (processNames.contains(processName.toLowerCase())) {
            toKillProcesses.add(process);
        }
    }

    private static void killProcesses(List<ProcessHandle> toKillProcesses) {
        HashSet seenPIDs = new HashSet();
        toKillProcesses.stream().filter(p -> seenPIDs.add(p.pid())).collect(Collectors.toList()).forEach(p -> {
            if (p.isAlive()) {
                String processName = ProcessUtil.extractProcessName(p.info().command());
                LogUtil.logInfo((String)("Kill PID: " + p.pid() + ", processName: " + processName));
                p.destroyForcibly();
            }
        });
    }

    private static String extractProcessName(Optional<String> command) {
        return command.map(cmd -> cmd.substring(cmd.lastIndexOf(File.separator) + 1)).orElse("Unknown");
    }

    public static void dumpChildProcesses(ProcessHandle process, int depth) {
        String prefix = " ".repeat(depth * 4);
        String command = process.info().command().orElse("Unknown");
        LogUtil.logInfo((String)(prefix + "|_ PID: " + process.pid() + ", command: " + command));
        process.children().forEach(child -> ProcessUtil.dumpChildProcesses(child, depth + 1));
    }
}

