/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.handlers;

import com.katalon.execution.controller.IExecutionController;
import com.kms.katalon.composer.project.constants.StringConstants;
import com.kms.katalon.controller.ProjectController;
import jakarta.inject.Inject;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;

public class CleanProjectHandler {
    @Inject
    private IExecutionController executionController;

    @CanExecute
    public boolean canExecute() {
        return !this.executionController.hasActiveExecutions();
    }

    @Execute
    public void execute() {
        final File tempDir = new File(ProjectController.getInstance().getTempDir());
        if (tempDir.exists()) {
            Job job = new Job(StringConstants.HAND_TEMP_CLEANER){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask(StringConstants.HAND_CLEANING_TEMP_FILES, CleanProjectHandler.this.getElementsCount(tempDir));
                        CleanProjectHandler.this.deleteFileRecursively(tempDir, monitor);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    private void deleteFileRecursively(File file, IProgressMonitor monitor) {
        if (file.getAbsolutePath().equalsIgnoreCase(ProjectController.getInstance().getNonremovableTempDir())) {
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        Object fileName = file.getName();
        if (((String)fileName).length() > 60) {
            fileName = ((String)fileName).substring(0, 60) + "...";
        }
        monitor.subTask(StringConstants.HAND_CLEANING_ITEM + (String)fileName);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                this.deleteFileRecursively(childFile, monitor);
                ++n2;
            }
        }
        file.delete();
        monitor.worked(1);
    }

    private int getElementsCount(File file) {
        int total = 1;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                total += this.getElementsCount(childFile);
                ++n2;
            }
        }
        return total;
    }
}

