/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.handlers;

import com.katalon.execution.controller.IExecutionController;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.project.constants.StringConstants;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import jakarta.inject.Inject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.BooleanSupplier;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.NavigationHistory;

public class CloseAndCleanupProjectHandler {
    @Inject
    private IExecutionController executionController;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;
    private static final String CANCEL_TO_CLOSE_DIALOG = "CANCEL_TO_CLOSE_DIALOG";

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null && !this.executionController.hasActiveExecutions();
    }

    @Execute
    public void execute(Shell shell) {
        boolean confirmed;
        BooleanSupplier closingHook = ProjectController.getInstance().getClosingHook();
        if (closingHook != null && !(confirmed = closingHook.getAsBoolean())) {
            return;
        }
        if (this.partService.saveAll(true)) {
            CloseAndCleanupProjectHandler.closeProject(this.partService, this.eventBroker, ProjectController.getInstance().getCurrentProject());
            this.eventBroker.send("EXPLORER/RELOAD_INPUT", Collections.emptyList());
            this.eventBroker.send("GLOBAL_VARIABLE/REFRESH", null);
            this.eventBroker.post("CONSOLE_LOG/RESET", null);
            this.eventBroker.post("JOB/REFRESH", null);
            MPartStack consolePartStack = (MPartStack)this.modelService.find("com.kms.katalon.partstack.console", (MUIElement)this.application);
            consolePartStack.getTags().add("Minimized");
            MPartStack rightPartStack = (MPartStack)this.modelService.find("com.kms.katalon.partstack.outline", (MUIElement)this.application);
            rightPartStack.getTags().add("Minimized");
            this.partService.activate((MPart)this.modelService.find("com.kms.katalon.part.welcome", (MUIElement)this.application));
            MWindow win = (MWindow)this.modelService.find("com.kms.katalon.composer.window.main", (MUIElement)this.application);
            win.setLabel(Platform.getProduct().getName());
            this.eventBroker.post("org/eclipse/e4/ui/renderer/requestEnablementUpdate", (Object)"ALL");
        }
    }

    private static void closeProject(EPartService partService, IEventBroker eventBroker, ProjectEntity project) {
        eventBroker.send("PROJECT/BDD/CLOSE", null);
        LauncherManager.getInstance().removeAllTerminated();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(false);
        CloseAndCleanupProjectHandler.closeActiveEditors(partService);
        CloseAndCleanupProjectHandler.navigationHistoryReset();
        eventBroker.post("PROJECT/CLOSE_AND_CLEAN", null);
        try {
            if (project != null) {
                ProjectController.getInstance().closeAndCleanupProject(project);
                eventBroker.send("PROJECT/CLOSED", (Object)project.getId());
            }
            eventBroker.send("START_PAGE/RELOAD", null);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openWarning(null, (String)StringConstants.WARN_TITLE, (String)StringConstants.HAND_WARN_MSG_UNABLE_TO_CLOSE_CURRENT_PROJ);
        }
    }

    private static void closeActiveEditors(EPartService partService) {
        for (MPart p : partService.getParts()) {
            if ((!p.getElementId().startsWith("com.kms.katalon.composer.content.") || !p.getElementId().endsWith(")")) && !"org.eclipse.e4.ui.compatibility.editor".equals(p.getElementId()) && !p.getElementId().endsWith(".md") && !p.getElementId().startsWith("com.kms.katalon.composer.webservice.part.collection.")) continue;
            partService.hidePart(p, true);
        }
    }

    private static void navigationHistoryReset() {
        try {
            Object[] pages;
            ObjectRepositoryController.getInstance().getObjectRepositoryLookup().clear();
            Object[] workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (ArrayUtils.isNotEmpty((Object[])workbenchWindows) && ArrayUtils.isNotEmpty((Object[])(pages = workbenchWindows[0].getPages()))) {
                Object page = pages[0];
                NavigationHistory history = (NavigationHistory)page.getNavigationHistory();
                Field fHistory = history.getClass().getDeclaredField("history");
                fHistory.setAccessible(true);
                fHistory.set(history, new ArrayList(50));
                fHistory.setAccessible(false);
                Method updateAction = history.getClass().getDeclaredMethod("updateActions", new Class[0]);
                updateAction.setAccessible(true);
                updateAction.invoke((Object)history, new Object[0]);
                updateAction.setAccessible(false);
            }
        }
        catch (Exception exception) {}
    }
}

