/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.handlers;

import com.kms.katalon.composer.components.impl.handler.AbstractHandler;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.reference.EntityReferenceIndexService;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.util.ExecutionTimeTracker;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;

public class IndexEntityHandler
extends AbstractHandler {
    private Job indexinEntityJob;
    private boolean needToIndex = false;

    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    public void execute() {
        if (this.indexinEntityJob == null) {
            this.indexinEntityJob = new Job("Indexing Entity..."){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask("Indexing Entity...", 3);
                        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
                        EntityReferenceIndexService.getInstance().switchProject(project.getEntityReferenceIndexPath());
                        monitor.worked(1);
                        IndexEntityHandler.prepareEntityReferenceIndex(project);
                        monitor.worked(1);
                        IndexEntityHandler.preloadTestEntities(project);
                        monitor.worked(1);
                        IndexEntityHandler.this.needToIndex = false;
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    catch (Exception e) {
                        LoggerSingleton.logError((Throwable)e);
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            this.indexinEntityJob.setUser(true);
        }
        if (this.indexinEntityJob.getState() == 4 || this.indexinEntityJob.getState() == 2) {
            return;
        }
        if (this.indexinEntityJob.getState() == 1) {
            this.indexinEntityJob.wakeUp();
            return;
        }
        this.indexinEntityJob.schedule();
    }

    @Inject
    @Optional
    public void subscribeIndexingEvent(@UIEventTopic(value="PROJECT/LOAD_PLUGIN_COMPLETED") Object eventData) {
        if (this.needToIndex) {
            this.execute();
        }
    }

    @Inject
    @Optional
    public void subscribeOpenedProjectEvent(@UIEventTopic(value="PROJECT/OPENED") Object eventData) {
        this.needToIndex = true;
    }

    private static void prepareEntityReferenceIndex(ProjectEntity project) {
        try {
            String taskName = "Scan files to index entity reference";
            ExecutionTimeTracker.getInstance().start(taskName);
            IFolder testCaseScriptFolder = GroovyUtil.getTestCaseScriptSourceFolder((ProjectEntity)project);
            testCaseScriptFolder.refreshLocal(2, null);
            List testCaseScriptFiles = GroovyUtil.getAllTestCaseScripts((ProjectEntity)project).stream().map(iFile -> iFile.getLocation().toFile()).collect(Collectors.toList());
            IFolder testSuiteFolder = GroovyUtil.getTestSuiteSourceFolder((ProjectEntity)project);
            testSuiteFolder.refreshLocal(2, null);
            List testSuiteScriptFiles = GroovyUtil.getAllTestSuiteScripts((ProjectEntity)project).stream().map(iFile -> iFile.getLocation().toFile()).collect(Collectors.toList());
            List<Object> testSuiteXmlFiles = new ArrayList();
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (Stream<Path> paths = Files.walk(Paths.get(testSuiteFolder.getLocation().toOSString(), new String[0]), new FileVisitOption[0]);){
                    testSuiteXmlFiles = paths.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> path.toString().endsWith(".ts")).map(Path::toFile).collect(Collectors.toList());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
            ArrayList allFiles = new ArrayList(testCaseScriptFiles);
            allFiles.addAll(testSuiteScriptFiles);
            allFiles.addAll(testSuiteXmlFiles);
            ExecutionTimeTracker.getInstance().stop(taskName);
            String taskName2 = "(Re)index entity reference if modified (" + allFiles.size() + " file(s))";
            ExecutionTimeTracker.getInstance().start(taskName2);
            EntityReferenceIndexService.getInstance().prepareIndexForNewlyOpenedProject(allFiles);
            ExecutionTimeTracker.getInstance().stop(taskName2);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e, (String)"Failed to prepare entity reference index");
        }
    }

    private static void preloadTestEntities(ProjectEntity project) {
        FolderController folderController = FolderController.getInstance();
        try {
            String taskName = "Preload test entities when opening project";
            ExecutionTimeTracker.getInstance().start(taskName);
            FolderEntity testObjectFolder = folderController.getObjectRepositoryRoot(project);
            int nTestObjects = folderController.getAllDescentdantEntities(testObjectFolder).size();
            FolderEntity testCaseFolder = folderController.getTestCaseRoot(project);
            int nTestCases = folderController.getAllDescentdantEntities(testCaseFolder).size();
            ExecutionTimeTracker.getInstance().stop(taskName);
            LoggerSingleton.logInfo((String)String.format("Finished preloading %d test object(s) and %d test case(s)", nTestObjects, nTestCases));
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e, (String)"Failed to preload test entities");
        }
    }
}

