/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.preference;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.application.ApplicationSingleton;
import com.kms.katalon.composer.components.controls.HoverableInformationComposite;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.services.ModelServiceSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.project.constants.StringConstants;
import com.kms.katalon.composer.project.handlers.OpenProjectHandler;
import com.kms.katalon.composer.testops.service.AnalyticsSettingStore;
import com.kms.katalon.controller.EntityNameController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProjectPropertiesPreferencePage
extends PreferencePage {
    private static ProjectController projectController = ProjectController.getInstance();
    private static final int DF_DESCRIPTION_LINE_NUMBER = 4;
    private Text txtName;
    private Text txtLocation;
    private Button chckProperties;
    private StyledText txtDescription;
    private ProjectEntity project;
    private Label lblErrorMessage;
    private Composite container;
    private Text txtTestOpsServerUrl;
    private Text txtProject;
    private Text txtRepoUrl;
    private Combo cbbProjectType;
    private String[] projectTypes = ProjectType.stringValues();

    public ProjectPropertiesPreferencePage() {
        this.project = projectController.getCurrentProject();
    }

    protected Control createContents(Composite parent) {
        if (ApplicationInfo.isPlatformStudio()) {
            return this.contentsForPlatformEditor(parent);
        }
        return this.contentsForStandaloneEditor(parent);
    }

    private Control contentsForStandaloneEditor(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout(2, false);
        glContainer.horizontalSpacing = 15;
        glContainer.verticalSpacing = 10;
        this.container.setLayout((Layout)glContainer);
        Label lblName = new Label(this.container, 0);
        lblName.setText(StringConstants.NAME);
        this.txtName = new Text(this.container, 2048);
        this.txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblLocation = new Label(this.container, 0);
        lblLocation.setText(StringConstants.VIEW_LBL_LOCATION);
        this.txtLocation = new Text(this.container, 2056);
        this.txtLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblDescription = new Label(this.container, 0);
        lblDescription.setText(StringConstants.VIEW_LBL_DESCRIPTION);
        this.txtDescription = new StyledText(this.container, 2818);
        this.txtDescription.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblProperties = new Label(this.container, 0);
        lblProperties.setText(StringConstants.VIEW_LBL_PROPERTIES);
        this.chckProperties = new Button(this.container, 32);
        this.chckProperties.setText(StringConstants.VIEW_PROPERTIES_CHECKBOX_DETAILS);
        GridData layout = new GridData(1808);
        layout.grabExcessVerticalSpace = false;
        GC graphicContext = new GC((Drawable)this.txtDescription);
        FontMetrics fm = graphicContext.getFontMetrics();
        layout.heightHint = 4 * fm.getHeight();
        this.txtDescription.setLayoutData((Object)layout);
        new Label(this.container, 0);
        this.lblErrorMessage = new Label(this.container, 64);
        this.lblErrorMessage.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.lblErrorMessage.setForeground(ColorUtil.getTextErrorColor());
        graphicContext.dispose();
        this.setInput();
        this.registerControlModifyListener();
        return this.container;
    }

    private Control contentsForPlatformEditor(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout(2, false);
        glContainer.horizontalSpacing = 15;
        glContainer.verticalSpacing = 10;
        this.container.setLayout((Layout)glContainer);
        Label lblTestOpsServerUrl = new Label(this.container, 0);
        lblTestOpsServerUrl.setText(StringConstants.LBL_TESTOPS_SERVER_URL);
        this.txtTestOpsServerUrl = new Text(this.container, 2048);
        this.txtTestOpsServerUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtTestOpsServerUrl.setEnabled(false);
        Label lblProject = new Label(this.container, 0);
        lblProject.setText(StringConstants.LBL_PROJECT);
        this.txtProject = new Text(this.container, 2056);
        this.txtProject.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtProject.setEnabled(false);
        Label lblRepoUrl = new Label(this.container, 0);
        lblRepoUrl.setText(StringConstants.LBL_REPOSITORY_URL);
        this.txtRepoUrl = new Text(this.container, 2056);
        this.txtRepoUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtRepoUrl.setEnabled(false);
        Label lblLocation = new Label(this.container, 0);
        lblLocation.setText(StringConstants.LBL_LOCAL_LOCATION);
        this.txtLocation = new Text(this.container, 2056);
        this.txtLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtLocation.setEnabled(false);
        Composite compositeLabelProjectType = new Composite(this.container, 0);
        GridLayout glDriverInfo = new GridLayout(2, false);
        glDriverInfo.marginHeight = 0;
        glDriverInfo.marginWidth = 0;
        glDriverInfo.horizontalSpacing = 0;
        compositeLabelProjectType.setLayout((Layout)glDriverInfo);
        Label lblProjectType = new Label(compositeLabelProjectType, 0);
        lblProjectType.setText(StringConstants.LBL_PROJECT_TYPE);
        new HoverableInformationComposite(compositeLabelProjectType, StringConstants.TOOLTIP_PROJECT_TYPE);
        this.cbbProjectType = new Combo(this.container, 8);
        this.cbbProjectType.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 1, 1));
        Label lblDescription = new Label(this.container, 0);
        lblDescription.setText(StringConstants.VIEW_LBL_DESCRIPTION);
        this.txtDescription = new StyledText(this.container, 2818);
        this.txtDescription.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblProperties = new Label(this.container, 0);
        lblProperties.setText(StringConstants.VIEW_LBL_PROPERTIES);
        this.chckProperties = new Button(this.container, 32);
        this.chckProperties.setText(StringConstants.VIEW_PROPERTIES_CHECKBOX_DETAILS);
        GridData layout = new GridData(1808);
        layout.grabExcessVerticalSpace = false;
        GC graphicContext = new GC((Drawable)this.txtDescription);
        FontMetrics fm = graphicContext.getFontMetrics();
        layout.heightHint = 4 * fm.getHeight();
        this.txtDescription.setLayoutData((Object)layout);
        new Label(this.container, 0);
        this.lblErrorMessage = new Label(this.container, 64);
        this.lblErrorMessage.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.lblErrorMessage.setForeground(ColorUtil.getTextErrorColor());
        graphicContext.dispose();
        this.setInputForPlatformEditor();
        this.registerControlModifyForPlatformListener();
        return this.container;
    }

    private void setInput() {
        this.txtName.setText(this.project.getName());
        this.txtLocation.setText(this.project.getFolderLocation());
        this.txtDescription.setText(this.project.getDescription());
        this.lblErrorMessage.setText("");
        this.chckProperties.setSelection(this.project.isTimeStampInProperties());
    }

    private void setInputForPlatformEditor() {
        this.txtTestOpsServerUrl.setText(ApplicationInfo.getTestOpsServer());
        AnalyticsSettingStore store = AnalyticsSettingStore.getStore((String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
        this.txtProject.setText(store.getProject() == null ? "" : store.getProject().getName());
        this.txtRepoUrl.setText(store.getGitRepositoryEntity() == null ? "" : store.getGitRepositoryEntity().getRepository());
        this.txtLocation.setText(this.project.getFolderLocation());
        this.cbbProjectType.setItems(this.projectTypes);
        int i = 0;
        while (i < this.projectTypes.length) {
            if (this.project.getType().name().equalsIgnoreCase(this.projectTypes[i])) {
                this.cbbProjectType.select(i);
                break;
            }
            ++i;
        }
        this.txtDescription.setText(this.project.getDescription());
        this.chckProperties.setSelection(this.project.isTimeStampInProperties());
        this.lblErrorMessage.setText("");
    }

    private void registerControlModifyListener() {
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectPropertiesPreferencePage.this.getApplyButton().setEnabled(ProjectPropertiesPreferencePage.this.validateProjectName());
            }
        });
        this.registerTextDescription();
    }

    private void registerTextDescription() {
        this.txtDescription.addListener(24, ControlUtils.getAutoHideStyledTextScrollbarListener);
        this.txtDescription.addListener(11, ControlUtils.getAutoHideStyledTextScrollbarListener);
    }

    private void registerControlModifyForPlatformListener() {
        this.registerTextDescription();
    }

    private boolean validateProjectName() {
        String newProjectName = this.txtName.getText();
        if (newProjectName.equals(this.project.getName())) {
            return true;
        }
        if (StringUtils.isBlank((String)newProjectName)) {
            this.lblErrorMessage.setText(StringConstants.VIEW_ERROR_MSG_PROJ_NAME_CANNOT_BE_BLANK);
            return false;
        }
        try {
            EntityNameController.getInstance().validateName(newProjectName);
        }
        catch (Exception e) {
            this.lblErrorMessage.setText(e.getMessage());
            return false;
        }
        this.lblErrorMessage.setText("");
        return true;
    }

    public boolean okToLeave() {
        return this.isNotOpenedYet() || this.isValidInput();
    }

    public boolean performOk() {
        if (this.isNotOpenedYet()) {
            return true;
        }
        boolean valid = this.isValidInput();
        if (valid) {
            this.updateProject();
        }
        return valid;
    }

    private void updateProject() {
        try {
            String localProjectName = this.txtName != null ? this.txtName.getText() : "";
            ProjectType projectType = this.cbbProjectType == null ? null : ProjectType.fromValue((String)this.projectTypes[this.cbbProjectType.getSelectionIndex()]);
            projectController.updateProject(localProjectName, this.txtDescription.getText(), this.project.getId(), this.chckProperties.getSelection(), projectType);
            OpenProjectHandler.updateProjectTitle(this.project, ModelServiceSingleton.getInstance().getModelService(), ApplicationSingleton.getInstance().getApplication());
            IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
            eventBroker.post("PROJECT/UPDATED", (Object)true);
            if (projectType != null) {
                eventBroker.post("TOOLBAR/RELOAD", null);
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
        }
    }

    private boolean isValidInput() {
        return this.lblErrorMessage.getText().isEmpty();
    }

    private boolean isNotOpenedYet() {
        return this.container == null || this.container.isDisposed();
    }

    protected void performDefaults() {
        this.setInput();
    }
}

