/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.sample;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.kms.katalon.composer.project.sample.SampleRemoteProject;
import com.kms.katalon.composer.project.sample.SampleRemoteProjectDeserializer;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.network.apache.services.ApacheHttpClient;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.preferences.eclipse.service.EclipseNetworkPreferences;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleRemoteProjectProvider {
    private static Logger logger = LoggerFactory.getLogger(SampleRemoteProjectProvider.class);
    private static List<SampleRemoteProject> cachedProjects;
    public static final String SAMPLE_REMOTE_PROJECT_DESCRIPTION_URL = "https://download.katalon.com/resources/sample_projects_v2.json";

    public static List<SampleRemoteProject> getCachedProjects() {
        if (cachedProjects == null) {
            cachedProjects = SampleRemoteProjectProvider.getSampleProjects();
            return cachedProjects;
        }
        return cachedProjects;
    }

    public static List<SampleRemoteProject> getSampleProjects() {
        INetworkPreferences networkPreferences = EclipseNetworkPreferences.getInstance();
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI uri = new URI(SAMPLE_REMOTE_PROJECT_DESCRIPTION_URL);
            ProxyConfig proxyConfig = networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
            HttpOptions httpOptions = new HttpOptions.Builder().proxy(proxyConfig).build();
            HttpResponse response = httpClient.get(uri, httpOptions);
            Gson gson = new GsonBuilder().registerTypeAdapter(SampleRemoteProject.class, (Object)new SampleRemoteProjectDeserializer()).create();
            Type type = new TypeToken<List<SampleRemoteProject>>(){}.getType();
            cachedProjects = new ArrayList<SampleRemoteProject>((Collection)gson.fromJson(response.getBody(), type));
            return cachedProjects;
        }
        catch (Exception exception) {
            cachedProjects = Collections.emptyList();
            return cachedProjects;
        }
    }

    public Map<Integer, File> getThumbnailFiles(SampleRemoteProject project) {
        File tempFileFolder = new File(ProjectController.getInstance().getTempDir(), "welcome/samples/images");
        tempFileFolder.mkdirs();
        return project.getThumbnails().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            try {
                File imageFile = new File(tempFileFolder, String.valueOf(UUID.randomUUID()) + ".png");
                imageFile.createNewFile();
                FileUtils.copyInputStreamToFile((InputStream)SampleRemoteProjectProvider.getInputStream((String)e.getValue() + "?raw=true"), (File)imageFile);
                return imageFile;
            }
            catch (HttpException | IOException | URISyntaxException throwable) {
                return null;
            }
        }));
    }

    public static InputStream getInputStream(String url) throws URISyntaxException, HttpException {
        INetworkPreferences networkPreferences = EclipseNetworkPreferences.getInstance();
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        URI uri = new URI(url);
        ProxyConfig proxyConfig = networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().proxy(proxyConfig).build();
        HttpResponse response = httpClient.get(uri, httpOptions);
        return response.getContent();
    }

    public static boolean checkInternetConection() {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            HttpResponse httpResponse = httpClient.get(new URI(SAMPLE_REMOTE_PROJECT_DESCRIPTION_URL));
            return httpResponse.getStatusCode() == 200;
        }
        catch (Exception e) {
            logger.error("Cannot connect to internet when getting sample remote project", (Throwable)e);
            return false;
        }
    }
}

