/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.application;

import com.katalon.execution.application.ai.ExecuteLlmServiceFactory;
import com.katalon.execution.application.network.ExecutionNetworkPreferences;
import com.katalon.execution.application.platform.ExecutionTestOpsController;
import com.katalon.execution.application.session.ExecutionSessionManager;
import com.katalon.execution.application.variable.CommonExecutionVariableManager;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.services.ILlmService;
import com.kms.katalon.ai.core.services.ILlmServiceFactory;
import com.kms.katalon.core.main.ExecutionServiceContext;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryService;
import com.kms.katalon.discovery.services.DiscoveryService;
import com.kms.katalon.network.apache.services.ApacheHttpClient;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.session.core.services.ISessionManager;
import com.kms.katalon.testops.core.services.ITestOpsController;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionMain {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ExecutionServiceContext serviceContext = ExecutionServiceContext.getInstance();
    private CommonExecutionVariableManager executionVariables = new CommonExecutionVariableManager();

    public void init() {
        try {
            this.injectCommonServices();
        }
        catch (Exception error) {
            this.logger.error("Failed to inject common services for execution mode", (Throwable)error);
        }
        try {
            this.initAIService();
        }
        catch (Exception error) {
            this.logger.error("Failed to initialize AI service", (Throwable)error);
        }
    }

    private void injectCommonServices() throws Exception {
        this.serviceContext.registerService(IHttpClient.class, ApacheHttpClient.class);
        ExecutionNetworkPreferences networkPrefsService = new ExecutionNetworkPreferences();
        networkPrefsService.setNetworkPrefs(this.executionVariables.getNetworkPrefs());
        this.serviceContext.registerService(INetworkPreferences.class, (Object)networkPrefsService);
        DiscoveryService discoveryService = new DiscoveryService();
        Map<ServerType, String> serverInfo = this.executionVariables.getServerInfo();
        discoveryService.setServerUrls(serverInfo);
        this.serviceContext.registerService(IDiscoveryService.class, (Object)discoveryService);
    }

    private void initAIService() throws Exception {
        this.serviceContext.registerService(ILlmServiceFactory.class, ExecuteLlmServiceFactory.class);
        ExecutionSessionManager executionSessionManager = new ExecutionSessionManager(this.executionVariables.getAccount(), this.executionVariables.getOrganization(), this.executionVariables.getUser(), this.executionVariables.getKatOneToken());
        this.serviceContext.registerService(ISessionManager.class, (Object)executionSessionManager);
        ExecutionTestOpsController executionTestOpsController = new ExecutionTestOpsController();
        this.serviceContext.registerService(ITestOpsController.class, (Object)executionTestOpsController);
        ILlmServiceFactory llmServiceFactory = (ILlmServiceFactory)this.serviceContext.getService(ILlmServiceFactory.class);
        if (llmServiceFactory instanceof ExecuteLlmServiceFactory) {
            ExecuteLlmServiceFactory executeLlmServiceFactory = (ExecuteLlmServiceFactory)llmServiceFactory;
            String appVersion = this.executionVariables.getAppVersion();
            executeLlmServiceFactory.setAppVersion(appVersion);
        }
        StudioAssistConfig config = this.executionVariables.getAIServiceConfig();
        ILlmService llmService = llmServiceFactory.createLlmService(config);
        this.serviceContext.registerService(ILlmService.class, (Object)llmService);
    }
}

