/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.application.ai;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.ai.core.model.config.AwsBedrockConfig;
import com.kms.katalon.ai.core.model.config.AzureOpenAIConfig;
import com.kms.katalon.ai.core.model.config.GeminiConfig;
import com.kms.katalon.ai.core.model.config.GenAIConfig;
import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.NoneConfig;
import com.kms.katalon.ai.core.model.config.OpenAIConfig;
import com.kms.katalon.ai.core.model.config.OpenAiCompatibleConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import java.io.IOException;

public class AIServiceConfigParser {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public StudioAssistConfig parse(String rawConfig) throws IOException {
        RawStudioAssistConfig raw = (RawStudioAssistConfig)MAPPER.readValue(rawConfig, RawStudioAssistConfig.class);
        if (raw == null || raw.type == null) {
            throw new IllegalArgumentException("Invalid AI service configuration: missing type field");
        }
        return switch (raw.type) {
            case LlmConfigType.AWS_BEDROCK -> (StudioAssistConfig)MAPPER.readValue(rawConfig, AwsBedrockConfig.class);
            case LlmConfigType.GEMINI -> (StudioAssistConfig)MAPPER.readValue(rawConfig, GeminiConfig.class);
            case LlmConfigType.AZURE_OPENAI -> (StudioAssistConfig)MAPPER.readValue(rawConfig, AzureOpenAIConfig.class);
            case LlmConfigType.GEN_AI -> (StudioAssistConfig)MAPPER.readValue(rawConfig, GenAIConfig.class);
            case LlmConfigType.OPENAI -> (StudioAssistConfig)MAPPER.readValue(rawConfig, OpenAIConfig.class);
            case LlmConfigType.OPENAI_COMPATIBLE -> (StudioAssistConfig)MAPPER.readValue(rawConfig, OpenAiCompatibleConfig.class);
            case LlmConfigType.NONE -> (StudioAssistConfig)MAPPER.readValue(rawConfig, NoneConfig.class);
            default -> throw new MatchException(null, null);
        };
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class RawStudioAssistConfig {
        public LlmConfigType type;

        private RawStudioAssistConfig() {
        }
    }
}

