/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.application.ai;

import com.kms.katalon.ai.services.GenAiClient;
import com.kms.katalon.network.core.model.Authentication;
import com.kms.katalon.network.core.model.BearerAuthentication;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.session.core.model.Account;
import com.kms.katalon.session.core.model.AuthenticationToken;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.User;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class ExecuteGenAiClient
extends GenAiClient {
    private String appVersion;

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public HttpOptions buildHttpOptions(Map<String, String> headers) {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.putIfAbsent("X-Client-App-Name", "katalon_studio");
        headers.putIfAbsent("X-Client-App-Module", "studioassist");
        headers.computeIfAbsent("X-Account-Id", k -> Optional.ofNullable(this.sessionManager.getAccount()).map(Account::getId).map(String::valueOf).orElse(null));
        headers.computeIfAbsent("X-Organization-Id", k -> Optional.ofNullable(this.sessionManager.getOrganization()).map(Organization::getId).map(String::valueOf).orElse(null));
        headers.computeIfAbsent("X-User-Id", k -> Optional.ofNullable(this.sessionManager.getUser()).map(User::getId).map(String::valueOf).orElse(null));
        headers.putIfAbsent("X-Client-App-Version", StringUtils.defaultString((String)this.appVersion));
        AuthenticationToken katOneToken = this.sessionManager.getKatOneToken();
        if (katOneToken == null) {
            throw new IllegalStateException("KatOne token is required to access KatalonAI service.");
        }
        BearerAuthentication authenticate = Authentication.BearerAuthentication((String)katOneToken.getAccessToken());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        return new HttpOptions.Builder().headers(headers).authentication((Authentication)authenticate).proxy(proxyConfig).build();
    }
}

