/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.application.ai;

import com.katalon.execution.application.ai.ExecuteGenAiClient;
import com.kms.katalon.ai.core.model.config.AwsBedrockConfig;
import com.kms.katalon.ai.core.model.config.AzureOpenAIConfig;
import com.kms.katalon.ai.core.model.config.GeminiConfig;
import com.kms.katalon.ai.core.model.config.GenAIConfig;
import com.kms.katalon.ai.core.model.config.OpenAIConfig;
import com.kms.katalon.ai.core.model.config.OpenAiCompatibleConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.services.ILlmService;
import com.kms.katalon.ai.core.services.ILlmServiceFactory;
import com.kms.katalon.ai.internal.IGenAiClient;
import com.kms.katalon.ai.internal.IGenAiClientFactory;
import com.kms.katalon.ai.services.AwsBedrockService;
import com.kms.katalon.ai.services.AzureOpenAiService;
import com.kms.katalon.ai.services.GeminiService;
import com.kms.katalon.ai.services.GenAiService;
import com.kms.katalon.ai.services.OpenAiCompatibleService;
import com.kms.katalon.ai.services.OpenAiService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class ExecuteLlmServiceFactory
implements IGenAiClientFactory,
ILlmServiceFactory {
    @Inject
    private IEclipseContext eclipseContext;
    private String appVersion;

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public ILlmService createLlmService(StudioAssistConfig config) {
        OpenAiService service;
        if (config instanceof OpenAIConfig) {
            OpenAIConfig openAiConfig = (OpenAIConfig)config;
            service = new OpenAiService(openAiConfig);
        } else if (config instanceof AzureOpenAIConfig) {
            AzureOpenAIConfig azureOpenAiConfig = (AzureOpenAIConfig)config;
            service = new AzureOpenAiService(azureOpenAiConfig);
        } else if (config instanceof GeminiConfig) {
            GeminiConfig geminiConfig = (GeminiConfig)config;
            service = new GeminiService(geminiConfig);
        } else if (config instanceof OpenAiCompatibleConfig) {
            OpenAiCompatibleConfig openAiCompatibleConfig = (OpenAiCompatibleConfig)config;
            service = new OpenAiCompatibleService(openAiCompatibleConfig);
        } else if (config instanceof AwsBedrockConfig) {
            AwsBedrockConfig awsBedrockConfig = (AwsBedrockConfig)config;
            service = new AwsBedrockService(awsBedrockConfig);
        } else if (config instanceof GenAIConfig) {
            service = new GenAiService(this.createGenAiClient());
        } else {
            return null;
        }
        ContextInjectionFactory.inject((Object)service, (IEclipseContext)this.eclipseContext);
        return service;
    }

    public IGenAiClient createGenAiClient() {
        ExecuteGenAiClient genAiClient = (ExecuteGenAiClient)((Object)ContextInjectionFactory.make(ExecuteGenAiClient.class, (IEclipseContext)this.eclipseContext));
        genAiClient.setAppVersion(this.appVersion);
        return genAiClient;
    }
}

