/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.application.network;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.network.core.model.config.ProxyAuthentication;
import com.kms.katalon.network.core.model.config.ProxyAuthenticationType;
import com.kms.katalon.network.core.model.config.ProxyBasicAuthentication;
import com.kms.katalon.network.core.model.config.ProxyNoAuthentication;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;

public class ProxyAuthenticationDeserializer
extends JsonDeserializer<ProxyAuthentication> {
    private static final Map<ProxyAuthenticationType, Class<? extends ProxyAuthentication>> REGISTRY = new EnumMap<ProxyAuthenticationType, Class<? extends ProxyAuthentication>>(ProxyAuthenticationType.class);

    static {
        REGISTRY.put(ProxyAuthenticationType.NONE, ProxyNoAuthentication.class);
        REGISTRY.put(ProxyAuthenticationType.BASIC, ProxyBasicAuthentication.class);
    }

    public ProxyAuthentication deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(parser);
        ProxyAuthenticationType type = ProxyAuthenticationType.valueOf((String)node.get("type").asText());
        Class<? extends ProxyAuthentication> clazz = REGISTRY.get(type);
        if (clazz == null) {
            throw new IllegalArgumentException("Unknown proxy type: " + String.valueOf(type));
        }
        return (ProxyAuthentication)mapper.treeToValue((TreeNode)node, clazz);
    }
}

