/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.application.network;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.network.core.model.config.ManualProxyConfig;
import com.kms.katalon.network.core.model.config.NoProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyOption;
import com.kms.katalon.network.core.model.config.SystemProxyConfig;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;

public class ProxyConfigDeserializer
extends JsonDeserializer<ProxyConfig> {
    private static final Map<ProxyOption, Class<? extends ProxyConfig>> REGISTRY = new EnumMap<ProxyOption, Class<? extends ProxyConfig>>(ProxyOption.class);

    static {
        REGISTRY.put(ProxyOption.MANUAL_CONFIG, ManualProxyConfig.class);
        REGISTRY.put(ProxyOption.NO_PROXY, NoProxyConfig.class);
        REGISTRY.put(ProxyOption.USE_SYSTEM, SystemProxyConfig.class);
    }

    public ProxyConfig deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(parser);
        JsonNode typeNode = node.get("type");
        if (typeNode == null || typeNode.isNull()) {
            throw new IllegalArgumentException("Missing required 'type' field in proxy configuration");
        }
        ProxyOption type = ProxyOption.valueOf((String)typeNode.asText());
        Class<? extends ProxyConfig> clazz = REGISTRY.get(type);
        if (clazz == null) {
            throw new IllegalArgumentException("Unknown proxy type: " + String.valueOf(type));
        }
        return (ProxyConfig)mapper.treeToValue((TreeNode)node, clazz);
    }
}

