/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.cucumber.plugin;

import com.kms.katalon.core.logging.KeywordLogger;
import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.Comment;
import io.cucumber.messages.types.DataTable;
import io.cucumber.messages.types.DocString;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Exception;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Group;
import io.cucumber.messages.types.ParseError;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleDocString;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.PickleStepArgument;
import io.cucumber.messages.types.PickleStepType;
import io.cucumber.messages.types.PickleTable;
import io.cucumber.messages.types.PickleTableCell;
import io.cucumber.messages.types.PickleTableRow;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.RuleChild;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.StepKeywordType;
import io.cucumber.messages.types.StepMatchArgument;
import io.cucumber.messages.types.StepMatchArgumentsList;
import io.cucumber.messages.types.TableCell;
import io.cucumber.messages.types.TableRow;
import io.cucumber.messages.types.TestCase;
import io.cucumber.messages.types.TestRunFinished;
import io.cucumber.messages.types.TestRunHookFinished;
import io.cucumber.messages.types.TestStep;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepResult;
import java.util.List;

public class EnvelopMasker {
    private static KeywordLogger logger = KeywordLogger.getInstance(EnvelopMasker.class);

    private EnvelopMasker() {
    }

    public static Envelope mask(Envelope envelop) {
        if (envelop == null) {
            return null;
        }
        if (envelop.getGherkinDocument().isPresent()) {
            return Envelope.of((GherkinDocument)envelop.getGherkinDocument().map(EnvelopMasker::mask).orElse(null));
        }
        if (envelop.getParseError().isPresent()) {
            return Envelope.of((ParseError)envelop.getParseError().map(EnvelopMasker::mask).orElse(null));
        }
        if (envelop.getPickle().isPresent()) {
            return Envelope.of((Pickle)envelop.getPickle().map(EnvelopMasker::mask).orElse(null));
        }
        if (envelop.getTestCase().isPresent()) {
            return Envelope.of((TestCase)envelop.getTestCase().map(EnvelopMasker::mask).orElse(null));
        }
        if (envelop.getTestRunFinished().isPresent()) {
            return Envelope.of((TestRunFinished)envelop.getTestRunFinished().map(EnvelopMasker::mask).orElse(null));
        }
        if (envelop.getTestStepFinished().isPresent()) {
            return Envelope.of((TestStepFinished)envelop.getTestStepFinished().map(EnvelopMasker::mask).orElse(null));
        }
        if (envelop.getTestRunHookFinished().isPresent()) {
            return Envelope.of((TestRunHookFinished)envelop.getTestRunHookFinished().map(EnvelopMasker::mask).orElse(null));
        }
        return envelop;
    }

    public static GherkinDocument mask(GherkinDocument doc) {
        if (doc == null) {
            return null;
        }
        return new GherkinDocument((String)doc.getUri().orElse(null), (Feature)doc.getFeature().map(EnvelopMasker::mask).orElse(null), doc.getComments().stream().map(EnvelopMasker::mask).toList());
    }

    public static Feature mask(Feature feature) {
        if (feature == null) {
            return null;
        }
        return new Feature(feature.getLocation(), feature.getTags(), feature.getLanguage(), feature.getKeyword(), EnvelopMasker.mask(feature.getName()), EnvelopMasker.mask(feature.getDescription()), feature.getChildren().stream().map(EnvelopMasker::mask).toList());
    }

    public static FeatureChild mask(FeatureChild child) {
        if (child == null) {
            return null;
        }
        return new FeatureChild(EnvelopMasker.mask(child.getRule().orElse(null)), EnvelopMasker.mask(child.getBackground().orElse(null)), EnvelopMasker.mask(child.getScenario().orElse(null)));
    }

    public static Rule mask(Rule rule) {
        if (rule == null) {
            return null;
        }
        return new Rule(rule.getLocation(), rule.getTags(), rule.getKeyword(), EnvelopMasker.mask(rule.getName()), EnvelopMasker.mask(rule.getDescription()), rule.getChildren().stream().map(EnvelopMasker::mask).toList(), rule.getId());
    }

    public static RuleChild mask(RuleChild child) {
        if (child == null) {
            return null;
        }
        return new RuleChild(EnvelopMasker.mask(child.getBackground().orElse(null)), EnvelopMasker.mask(child.getScenario().orElse(null)));
    }

    public static Background mask(Background background) {
        if (background == null) {
            return null;
        }
        return new Background(background.getLocation(), background.getKeyword(), EnvelopMasker.mask(background.getName()), EnvelopMasker.mask(background.getDescription()), background.getSteps().stream().map(EnvelopMasker::mask).toList(), background.getId());
    }

    public static Scenario mask(Scenario scenario) {
        if (scenario == null) {
            return null;
        }
        return new Scenario(scenario.getLocation(), scenario.getTags(), scenario.getKeyword(), EnvelopMasker.mask(scenario.getName()), EnvelopMasker.mask(scenario.getDescription()), scenario.getSteps().stream().map(EnvelopMasker::mask).toList(), scenario.getExamples().stream().map(EnvelopMasker::mask).toList(), scenario.getId());
    }

    public static Step mask(Step step) {
        if (step == null) {
            return null;
        }
        return new Step(step.getLocation(), step.getKeyword(), (StepKeywordType)step.getKeywordType().orElse(null), EnvelopMasker.mask(step.getText()), (DocString)step.getDocString().map(EnvelopMasker::mask).orElse(null), (DataTable)step.getDataTable().map(EnvelopMasker::mask).orElse(null), step.getId());
    }

    public static Examples mask(Examples examples) {
        if (examples == null) {
            return null;
        }
        return new Examples(examples.getLocation(), examples.getTags(), examples.getKeyword(), EnvelopMasker.mask(examples.getName()), EnvelopMasker.mask(examples.getDescription()), EnvelopMasker.mask(examples.getTableHeader().orElse(null)), examples.getTableBody().stream().map(EnvelopMasker::mask).toList(), examples.getId());
    }

    public static DocString mask(DocString docString) {
        if (docString == null) {
            return null;
        }
        return new DocString(docString.getLocation(), (String)docString.getMediaType().orElse(null), EnvelopMasker.mask(docString.getContent()), docString.getDelimiter());
    }

    public static DataTable mask(DataTable dataTable) {
        if (dataTable == null) {
            return null;
        }
        return new DataTable(dataTable.getLocation(), dataTable.getRows().stream().map(EnvelopMasker::mask).toList());
    }

    public static TableRow mask(TableRow tableRow) {
        if (tableRow == null) {
            return null;
        }
        return new TableRow(tableRow.getLocation(), tableRow.getCells().stream().map(EnvelopMasker::mask).toList(), tableRow.getId());
    }

    public static TableCell mask(TableCell tableCell) {
        if (tableCell == null) {
            return null;
        }
        return new TableCell(tableCell.getLocation(), EnvelopMasker.mask(tableCell.getValue()));
    }

    public static Pickle mask(Pickle pickle) {
        if (pickle == null) {
            return null;
        }
        return new Pickle(pickle.getId(), pickle.getUri(), EnvelopMasker.mask(pickle.getName()), pickle.getLanguage(), pickle.getSteps().stream().map(EnvelopMasker::mask).toList(), pickle.getTags(), pickle.getAstNodeIds());
    }

    public static PickleStep mask(PickleStep pickleStep) {
        if (pickleStep == null) {
            return null;
        }
        return new PickleStep(EnvelopMasker.mask(pickleStep.getArgument().orElse(null)), pickleStep.getAstNodeIds(), pickleStep.getId(), (PickleStepType)pickleStep.getType().orElse(null), EnvelopMasker.mask(pickleStep.getText()));
    }

    public static PickleStepArgument mask(PickleStepArgument arg) {
        if (arg == null) {
            return null;
        }
        return new PickleStepArgument(EnvelopMasker.mask(arg.getDocString().orElse(null)), EnvelopMasker.mask(arg.getDataTable().orElse(null)));
    }

    public static PickleDocString mask(PickleDocString pickleDocString) {
        if (pickleDocString == null) {
            return null;
        }
        return new PickleDocString((String)pickleDocString.getMediaType().orElse(null), EnvelopMasker.mask(pickleDocString.getContent()));
    }

    public static PickleTable mask(PickleTable pickleTable) {
        if (pickleTable == null) {
            return null;
        }
        return new PickleTable(pickleTable.getRows().stream().map(EnvelopMasker::mask).toList());
    }

    public static PickleTableRow mask(PickleTableRow row) {
        if (row == null) {
            return null;
        }
        return new PickleTableRow(row.getCells().stream().map(EnvelopMasker::mask).toList());
    }

    public static PickleTableCell mask(PickleTableCell cell) {
        if (cell == null) {
            return null;
        }
        return new PickleTableCell(EnvelopMasker.mask(cell.getValue()));
    }

    public static TestCase mask(TestCase testCase) {
        if (testCase == null) {
            return null;
        }
        return new TestCase(testCase.getId(), testCase.getPickleId(), testCase.getTestSteps().stream().map(EnvelopMasker::mask).toList(), (String)testCase.getTestRunStartedId().orElse(null));
    }

    public static TestStep mask(TestStep testStep) {
        if (testStep == null) {
            return null;
        }
        return new TestStep((String)testStep.getHookId().orElse(null), testStep.getId(), (String)testStep.getPickleStepId().orElse(null), (List)testStep.getStepDefinitionIds().orElse(null), (List)testStep.getStepMatchArgumentsLists().map(m -> m.stream().map(EnvelopMasker::mask).toList()).orElse(null));
    }

    public static StepMatchArgumentsList mask(StepMatchArgumentsList argumentsList) {
        if (argumentsList == null) {
            return null;
        }
        return new StepMatchArgumentsList(argumentsList.getStepMatchArguments().stream().map(EnvelopMasker::mask).toList());
    }

    public static StepMatchArgument mask(StepMatchArgument argument) {
        if (argument == null) {
            return null;
        }
        return new StepMatchArgument(EnvelopMasker.mask(argument.getGroup()), (String)argument.getParameterTypeName().orElse(null));
    }

    public static Group mask(Group group) {
        if (group == null) {
            return null;
        }
        return new Group(group.getChildren().stream().map(EnvelopMasker::mask).toList(), (Long)group.getStart().orElse(null), EnvelopMasker.mask(group.getValue().orElse(null)));
    }

    public static Comment mask(Comment comment) {
        if (comment == null) {
            return null;
        }
        return new Comment(comment.getLocation(), EnvelopMasker.mask(comment.getText()));
    }

    public static TestRunFinished mask(TestRunFinished testRunFinished) {
        if (testRunFinished == null) {
            return null;
        }
        return new TestRunFinished(EnvelopMasker.mask(testRunFinished.getMessage().orElse(null)), testRunFinished.getSuccess(), testRunFinished.getTimestamp(), EnvelopMasker.mask(testRunFinished.getException().orElse(null)), (String)testRunFinished.getTestRunStartedId().orElse(null));
    }

    public static TestStepFinished mask(TestStepFinished testStepFinished) {
        if (testStepFinished == null) {
            return null;
        }
        return new TestStepFinished(testStepFinished.getTestCaseStartedId(), testStepFinished.getTestStepId(), EnvelopMasker.mask(testStepFinished.getTestStepResult()), testStepFinished.getTimestamp());
    }

    public static TestRunHookFinished mask(TestRunHookFinished testRunHookFinished) {
        if (testRunHookFinished == null) {
            return null;
        }
        return new TestRunHookFinished(testRunHookFinished.getTestRunHookStartedId(), EnvelopMasker.mask(testRunHookFinished.getResult()), testRunHookFinished.getTimestamp());
    }

    public static TestStepResult mask(TestStepResult result) {
        if (result == null) {
            return null;
        }
        return new TestStepResult(result.getDuration(), EnvelopMasker.mask(result.getMessage().orElse(null)), result.getStatus(), EnvelopMasker.mask(result.getException().orElse(null)));
    }

    public static Exception mask(Exception exception) {
        if (exception == null) {
            return null;
        }
        return new Exception(exception.getType(), EnvelopMasker.mask(exception.getMessage().orElse(null)), (String)exception.getStackTrace().orElse(null));
    }

    public static ParseError mask(ParseError error) {
        if (error == null) {
            return null;
        }
        return new ParseError(error.getSource(), EnvelopMasker.mask(error.getMessage()));
    }

    public static String mask(String value) {
        return logger.maskSecureValues(value);
    }
}

