/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.resource;

import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.resource.ClasspathSupport;
import io.cucumber.core.resource.PathScanner;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class ClasspathScanner {
    private static final Logger log = LoggerFactory.getLogger(ClasspathScanner.class);
    private static final String CLASS_FILE_SUFFIX = ".class";
    private static final String PACKAGE_INFO_FILE_NAME = "package-info.class";
    private static final String MODULE_INFO_FILE_NAME = "module-info.class";
    private static final Predicate<Class<?>> NULL_FILTER = aClass -> true;
    private final PathScanner pathScanner = new PathScanner();
    private final Supplier<ClassLoader> classLoaderSupplier;

    public ClasspathScanner(Supplier<ClassLoader> classLoaderSupplier) {
        this.classLoaderSupplier = classLoaderSupplier;
    }

    public <T> List<Class<? extends T>> scanForSubClassesInPackage(String packageName, Class<T> parentClass) {
        return this.scanForClassesInPackage(packageName, ClasspathScanner.isSubClassOf(parentClass)).stream().map(aClass -> aClass.asSubclass(parentClass)).collect(Collectors.toList());
    }

    private List<Class<?>> scanForClassesInPackage(String packageName, Predicate<Class<?>> classFilter) {
        ClasspathSupport.requireValidPackageName((String)packageName);
        Objects.requireNonNull(classFilter, "classFilter must not be null");
        List rootUris = ClasspathSupport.getUrisForPackage((ClassLoader)this.getClassLoader(), (String)packageName);
        return this.findClassesForUris(rootUris, packageName, classFilter);
    }

    private static <T> Predicate<Class<?>> isSubClassOf(Class<T> parentClass) {
        return aClass -> !parentClass.equals(aClass) && parentClass.isAssignableFrom((Class<?>)aClass);
    }

    private ClassLoader getClassLoader() {
        return this.classLoaderSupplier.get();
    }

    private List<Class<?>> findClassesForUris(List<URI> baseUris, String packageName, Predicate<Class<?>> classFilter) {
        return baseUris.stream().map(baseUri -> this.findClassesForUri((URI)baseUri, packageName, classFilter)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    private List<Class<?>> findClassesForUri(URI baseUri, String packageName, Predicate<Class<?>> classFilter) {
        ArrayList classes = new ArrayList();
        this.pathScanner.findResourcesForUri(baseUri, path -> ClasspathScanner.isNotModuleInfo(path) && ClasspathScanner.isNotPackageInfo(path) && ClasspathScanner.isClassFile(path), this.processClassFiles(packageName, classFilter, classes::add));
        return classes;
    }

    private static boolean isNotModuleInfo(Path path) {
        return !path.endsWith(MODULE_INFO_FILE_NAME);
    }

    private static boolean isNotPackageInfo(Path path) {
        return !path.endsWith(PACKAGE_INFO_FILE_NAME);
    }

    private static boolean isClassFile(Path file) {
        return file.getFileName().toString().endsWith(CLASS_FILE_SUFFIX);
    }

    private Function<Path, Consumer<Path>> processClassFiles(String basePackageName, Predicate<Class<?>> classFilter, Consumer<Class<?>> classConsumer) {
        return baseDir -> classFile -> {
            String fqn = ClasspathSupport.determineFullyQualifiedClassName((Path)baseDir, (String)basePackageName, (Path)classFile);
            this.safelyLoadClass(fqn).filter(classFilter).ifPresent(classConsumer);
        };
    }

    private Optional<Class<?>> safelyLoadClass(String fqn) {
        try {
            return Optional.ofNullable(this.getClassLoader().loadClass(fqn));
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            return Optional.empty();
        }
    }

    public List<Class<?>> scanForClassesInPackage(String packageName) {
        return this.scanForClassesInPackage(packageName, NULL_FILTER);
    }
}

