/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public final class CryptoUtil {
    private static final String DF_ALGORITHM = "PBEwithSHA1AndDESede";
    private static final String DF_SALT = "K@tal0n STudlO";
    private static final String DF_SECRET_KEY = "S3cReT K3i";
    private static final int DF_ITERATION = 20;
    private static final String DF_ENCODING = "UTF-8";

    private CryptoUtil() {
    }

    public static CrytoInfo getDefault(String data) {
        return CryptoUtil.create(DF_ALGORITHM, data, DF_SALT.getBytes(), DF_SECRET_KEY);
    }

    public static CrytoInfo getDefault(String salt, String data) {
        return CryptoUtil.create(DF_ALGORITHM, data, salt.getBytes(), DF_SECRET_KEY);
    }

    public static CrytoInfo create(String algorithm, String data, byte[] salt, String privateKey) {
        CrytoInfo cryptoInfo = new CrytoInfo();
        cryptoInfo.algorithm = algorithm;
        cryptoInfo.data = data;
        cryptoInfo.salt = salt;
        cryptoInfo.privateKey = privateKey;
        return cryptoInfo;
    }

    public static CrytoInfo create(String algorithmn, String data, byte[] salt, String privateKey, int iteration) {
        CrytoInfo cryptoInfo = CryptoUtil.create(algorithmn, data, salt, privateKey);
        cryptoInfo.iteration = iteration;
        return cryptoInfo;
    }

    public static CrytoInfo create(String algorithmn, String data, byte[] salt, String privateKey, int iteration, String encode) {
        CrytoInfo cryptoInfo = CryptoUtil.create(algorithmn, data, salt, privateKey, iteration);
        cryptoInfo.encode = encode;
        return cryptoInfo;
    }

    public static String encode(CrytoInfo cryptoInfo) throws GeneralSecurityException, UnsupportedEncodingException {
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(cryptoInfo.algorithm);
        SecretKey key = keyFactory.generateSecret(new PBEKeySpec(cryptoInfo.privateKey.toCharArray()));
        Cipher pbeCipher = Cipher.getInstance(cryptoInfo.algorithm);
        pbeCipher.init(1, (Key)key, new PBEParameterSpec(cryptoInfo.salt, cryptoInfo.iteration));
        return Base64.getEncoder().encodeToString(pbeCipher.doFinal(cryptoInfo.data.getBytes(cryptoInfo.encode)));
    }

    public static String decode(CrytoInfo cryptoInfo) throws GeneralSecurityException, IOException {
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(cryptoInfo.algorithm);
        SecretKey key = keyFactory.generateSecret(new PBEKeySpec(cryptoInfo.privateKey.toCharArray()));
        Cipher pbeCipher = Cipher.getInstance(cryptoInfo.algorithm);
        pbeCipher.init(2, (Key)key, new PBEParameterSpec(cryptoInfo.salt, cryptoInfo.iteration));
        return new String(pbeCipher.doFinal(Base64.getDecoder().decode(cryptoInfo.data)), cryptoInfo.encode);
    }

    public static class CrytoInfo {
        private String data;
        private String algorithm;
        private byte[] salt;
        private String privateKey;
        private int iteration = 20;
        private String encode = "UTF-8";
    }
}

