/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class ExecutionTimeTracker {
    public static final ExecutionTimeTracker singleton = new ExecutionTimeTracker();
    private final Map<String, Long> startTimes = new ConcurrentHashMap<String, Long>();
    private Function<String, Void> logFunction;

    public static ExecutionTimeTracker getInstance() {
        return singleton;
    }

    public void start(String taskName) {
        if (this.logFunction == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.startTimes.put(taskName, startTime);
        this.logFunction.apply("[TimeTracker] Task started: '" + taskName + "'");
    }

    public void stop(String taskName) {
        if (this.logFunction == null) {
            return;
        }
        Long startTime = this.startTimes.get(taskName);
        if (startTime == null) {
            return;
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        this.logFunction.apply("[TimeTracker] Task ended: '" + taskName + "'. Elapsed time = " + duration + " ms");
        this.startTimes.remove(taskName);
    }

    public void setLogFunction(Function<String, Void> logFunction) {
        this.logFunction = logFunction;
    }
}

