/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.util.jdt;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.kms.katalon.util.TypeUtil;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class JdtUtil {
    private static final LoadingCache<UnresolvedSignature, String[][]> typeResolutionCache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<UnresolvedSignature, String[][]>(){

        public String[][] load(UnresolvedSignature unresolvedSignature) throws Exception {
            String[][] resolutionResult = unresolvedSignature.getType().resolveType(unresolvedSignature.getValue());
            return resolutionResult != null ? resolutionResult : new String[0][0];
        }
    });

    public static IMethod findMethod(IProject project, String className, String methodName, String[] parameterTypes) throws JavaModelException, IllegalArgumentException, ExecutionException {
        IMethod[] methods;
        IType type = JdtUtil.findType(project, className);
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (JdtUtil.isSameMethod(method, className, methodName, parameterTypes, false)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public static IMethod findMethod(IProject project, String className, String methodName, int numOfParams) throws JavaModelException {
        IMethod[] methods;
        IType type = JdtUtil.findType(project, className);
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.getElementName().equals(methodName) && numOfParams == method.getParameters().length) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public static IMethod findMethodWithLooseParamTypesMatching(IProject project, String className, String methodName, String[] parameterTypes) throws JavaModelException, IllegalArgumentException, ExecutionException {
        IMethod[] methods;
        IType type = JdtUtil.findType(project, className);
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (JdtUtil.isSameMethod(method, className, methodName, parameterTypes, true)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isSameMethod(IMethod method, String className, String methodName, String[] parameterTypes, boolean useLooseParameterTypesChecking) throws JavaModelException, IllegalArgumentException, ExecutionException {
        boolean hasSameParameterTypes;
        String className1 = method.getDeclaringType().getFullyQualifiedName();
        String methodName1 = method.getElementName();
        String[] parameterTypes1 = JdtUtil.getParameterTypes(method);
        boolean bl = hasSameParameterTypes = useLooseParameterTypesChecking ? TypeUtil.primitiveAwareSameTypesCheckWithLooseTypeMatching(parameterTypes, parameterTypes1) : TypeUtil.primitiveAwareSameTypesCheck(parameterTypes, parameterTypes1);
        return className1.equals(className) && methodName1.equals(methodName) && hasSameParameterTypes;
    }

    private static String[] getParameterTypes(IMethod method) throws JavaModelException, IllegalArgumentException, ExecutionException {
        String[] types;
        ArrayList<String> parameterTypes = new ArrayList<String>();
        String[] stringArray = types = method.getParameterTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            parameterTypes.add(JdtUtil.getReadableType(type, method));
            ++n2;
        }
        return parameterTypes.toArray(new String[parameterTypes.size()]);
    }

    private static String getReadableType(String typeSignature, IMethod method) throws IllegalArgumentException, JavaModelException, ExecutionException {
        String resolvedTypeSignature = JdtUtil.resolveTypeSignature(method, typeSignature);
        String readableType = Signature.toString((String)resolvedTypeSignature).replace("/", ".");
        return readableType;
    }

    private static String resolveTypeSignature(IMethod method, String typeSignature) throws JavaModelException, ExecutionException {
        int count = Signature.getArrayCount((String)typeSignature);
        String elementTypeSignature = Signature.getElementType((String)typeSignature);
        if (elementTypeSignature.length() == 1) {
            return typeSignature;
        }
        String elementTypeName = Signature.toString((String)elementTypeSignature);
        IType type = method.getDeclaringType();
        UnresolvedSignature unresolvedSignature = new UnresolvedSignature(type, elementTypeName);
        String[][] resolvedElementTypeNames = (String[][])typeResolutionCache.get((Object)unresolvedSignature);
        if (resolvedElementTypeNames == null || resolvedElementTypeNames.length != 1) {
            ITypeParameter typeParameter = method.getTypeParameter(elementTypeName);
            if (!typeParameter.exists()) {
                typeParameter = type.getTypeParameter(elementTypeName);
            }
            if (typeParameter.exists()) {
                String[] bounds = typeParameter.getBounds();
                if (bounds.length == 0) {
                    return "Ljava/lang/Object;";
                }
                String bound = Signature.createTypeSignature((String)bounds[0], (boolean)false);
                return Signature.createArraySignature((String)JdtUtil.resolveTypeSignature(method, bound), (int)count);
            }
            return null;
        }
        String[] types = resolvedElementTypeNames[0];
        types[1] = types[1].replace('.', '$');
        String resolvedElementTypeName = Signature.toQualifiedName((String[])types);
        String resolvedElementTypeSignature = "";
        if (types[0].equals("")) {
            resolvedElementTypeName = resolvedElementTypeName.substring(1);
            resolvedElementTypeSignature = Signature.createTypeSignature((String)resolvedElementTypeName, (boolean)true);
        } else {
            resolvedElementTypeSignature = Signature.createTypeSignature((String)resolvedElementTypeName, (boolean)true).replace('.', '/');
        }
        return Signature.createArraySignature((String)resolvedElementTypeSignature, (int)count);
    }

    public static IType findType(IProject project, String className) throws JavaModelException {
        IJavaProject javaProject = JdtUtil.getJavaProject(project);
        return javaProject.findType(className);
    }

    public static String findJavadoc(IJavaElement element) throws JavaModelException {
        IMember member;
        if (element instanceof ILocalVariable) {
            member = ((ILocalVariable)element).getDeclaringMember();
        } else if (element instanceof ITypeParameter) {
            member = ((ITypeParameter)element).getDeclaringMember();
        } else if (element instanceof IMember) {
            member = (IMember)element;
        } else {
            return null;
        }
        IBuffer buf = member.getOpenable().getBuffer();
        if (buf == null) {
            return null;
        }
        ISourceRange javadocRange = member.getJavadocRange();
        if (javadocRange == null) {
            return "";
        }
        return buf.getText(javadocRange.getOffset(), javadocRange.getLength());
    }

    private static IJavaProject getJavaProject(IProject project) {
        return JavaCore.create((IProject)project);
    }

    private static class UnresolvedSignature {
        private IType type;
        private String typeName;
        private String value;
        private String projectPath;

        public UnresolvedSignature(IType type, String value) {
            this.type = type;
            this.typeName = type.getFullyQualifiedName();
            this.projectPath = type.getJavaProject().getPath().toOSString();
            this.value = value;
        }

        public IType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.projectPath == null ? 0 : this.projectPath.hashCode());
            result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnresolvedSignature other = (UnresolvedSignature)obj;
            if (this.projectPath == null ? other.projectPath != null : !this.projectPath.equals(other.projectPath)) {
                return false;
            }
            if (this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

