package com.kms.katalon.core.windows.driver;

import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.DesiredCapabilities;

public class WindowsDesiredCapsBuilder {
    // Supported caps from FlaUI WebDriver
    // https://github.com/FlaUI/FlaUI.WebDriver?tab=readme-ov-file#capabilities
    private static final String CAPS_AUTOMATION_NAME = "appium:automationName";

    private static final String CAPS_APP = "appium:app";

    private static final String CAPS_APP_WORKING_DIR = "appium:appWorkingDir";

    private static final String CAPS_APP_ARGS = "appium:appArguments";

    private static final String CAPS_APP_TOP_LEVEL_WINDOW = "appium:appTopLevelWindow";

    private static final String CAPS_APP_TOP_LEVEL_WINDOW_TITLE_MATCH = "appium:appTopLevelWindowTitleMatch";
    
    public static final String ROOT_APP = "Root";

    private DesiredCapabilities desiredCapabilities;

    public WindowsDesiredCapsBuilder() {
        this.desiredCapabilities = new DesiredCapabilities();
        this.desiredCapabilities.setCapability(CAPS_AUTOMATION_NAME, "FlaUI");
    }

    public WindowsDesiredCapsBuilder withApp(String value) {
        this.desiredCapabilities.setCapability(CAPS_APP, value);
        return this;
    }

    public WindowsDesiredCapsBuilder withRootApp() {
        this.desiredCapabilities.setCapability(CAPS_APP, ROOT_APP);
        return this;
    }

    public WindowsDesiredCapsBuilder withAppWorkingDir(String value) {
        this.desiredCapabilities.setCapability(CAPS_APP_WORKING_DIR, value);
        return this;
    }

    public WindowsDesiredCapsBuilder withAppArguments(String value) {
        this.desiredCapabilities.setCapability(CAPS_APP_ARGS, value);
        return this;
    }

    public WindowsDesiredCapsBuilder withAppTopLevelWindow(String value) {
        this.desiredCapabilities.setCapability(CAPS_APP_TOP_LEVEL_WINDOW, value);
        return this;
    }

    public WindowsDesiredCapsBuilder withAppTopLevelWindowTitleMatch(String value) {
        this.desiredCapabilities.setCapability(CAPS_APP_TOP_LEVEL_WINDOW_TITLE_MATCH, value);
        return this;
    }

    public WindowsDesiredCapsBuilder merge(Map<String, Object> value) {
        this.desiredCapabilities.merge(new DesiredCapabilities(value));
        return this;
    }

    public WindowsDesiredCapsBuilder merge(DesiredCapabilities value) {
        this.desiredCapabilities.merge(value);
        return this;
    }

    public DesiredCapabilities build() {
        // Cleanup invalid capabilities before building the final one. Or we will get exceptions when creating sessions.
        // See: https://github.com/FlaUI/FlaUI.WebDriver/blob/83d7c3f28884dde40b5448bddd8edbd808ff304e/src/FlaUI.WebDriver/Controllers/SessionController.cs#L163-L176
        String app = (String) this.desiredCapabilities.getCapability(CAPS_APP);
        
        if (StringUtils.isBlank(app) || ROOT_APP.equalsIgnoreCase(app)) {
            this.desiredCapabilities.setCapability(CAPS_APP_ARGS, (Object)null);
            this.desiredCapabilities.setCapability(CAPS_APP_WORKING_DIR, (Object)null);
        }
        // For UWP (Universal Windows Platform) apps (ends with "!App"), the working dir is irrelevant 
        else if (app.endsWith("!App")) {
            this.desiredCapabilities.setCapability(CAPS_APP_WORKING_DIR, (Object)null);
        }

        return this.desiredCapabilities;
    }
}
