package com.kms.katalon.core.webservice.keyword.builtin

import java.text.MessageFormat
import java.util.stream.Collectors

import org.apache.commons.lang3.StringUtils

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepErrorException
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.KeywordMain
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.logging.model.TestStatus
import com.kms.katalon.core.main.TestCaseMain
import com.kms.katalon.core.main.TestResult
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.testcase.TestCaseBinding
import com.kms.katalon.core.testobject.RequestObject
import com.kms.katalon.core.testobject.ResponseObject
import com.kms.katalon.core.testobject.ValidationStatus
import com.kms.katalon.core.testobject.ValidationStep
import com.kms.katalon.core.webservice.common.HarLogger
import com.kms.katalon.core.webservice.common.ServiceRequestFactory
import com.kms.katalon.core.webservice.constants.CoreWebserviceMessageConstants
import com.kms.katalon.core.webservice.constants.StringConstants
import com.kms.katalon.core.webservice.helper.WebServiceCommonHelper
import com.kms.katalon.core.webservice.helper.WebServiceValidationHelper
import com.kms.katalon.core.webservice.keyword.internal.WebserviceAbstractKeyword
import com.kms.katalon.core.webservice.verification.WSResponseManager
import com.networknt.schema.Error

import groovy.transform.CompileStatic

@Action(value = "sendRequestAndVerify")
public class SendRequestAndVerifyKeyword extends WebserviceAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        RequestObject request = (RequestObject) params[0]
        FailureHandling flowControl = (FailureHandling)(params.length > 1 && params[1] instanceof FailureHandling ? params[1] : RunConfiguration.getDefaultFailureHandling())
        return sendRequestAndVerify(request,flowControl)
    }

    @CompileStatic
    public ResponseObject sendRequestAndVerify(RequestObject request, FailureHandling flowControl) throws Exception {
        Object object = KeywordMain.runKeyword({
            WebServiceCommonHelper.checkRequestObject(request)
            HarLogger harLogger = new HarLogger()
            boolean enableHarFileGeneration = RunConfiguration.getHarFileGeneration();
            if(enableHarFileGeneration) {
                harLogger.initHarFile()
            }

            ResponseObject response = WebServiceCommonHelper.sendRequest(request)

            if(enableHarFileGeneration) {
                harLogger.logHarFile(request, response, RunConfiguration.getReportFolder())
            }

            logger.logDebug(StringConstants.KW_LOG_INFO_VERIFICATION_START)
            doVerification(request, response, flowControl);

            logger.logDebug(StringConstants.KW_LOG_INFO_VALIDATION_START)
            doValidation(request, response, flowControl);

            logger.logPassed(StringConstants.KW_LOG_PASSED_SEND_REQUEST_AND_VERIFY_SUCCESS)
            return response;
        }, flowControl, StringConstants.KW_LOG_FAILED_CANNOT_SEND_REQUEST_AND_VERIFY)
        if (object instanceof ResponseObject) {
            return (ResponseObject) object
        }
        return null
    }

    private void doVerification(RequestObject request, ResponseObject responseObject, FailureHandling flowControl) {
        String verificationScript = request.getVerificationScript()
        WSResponseManager.getInstance().setCurrentRequest(request)
        WSResponseManager.getInstance().setCurrentResponse(responseObject)

        TestResult result = TestCaseMain.runWSVerificationScript(createTestCaseBinding(request),
                verificationScript, flowControl, true);

        switch(result.getTestStatus().getStatusValue()) {
            case TestStatus.TestStatusValue.FAILED:
                KeywordMain.stepFailed(StringConstants.KW_LOG_VERIFICATION_STEP_FAILED, flowControl);
                break
            case TestStatus.TestStatusValue.ERROR:
                throw new StepErrorException(StringConstants.KW_LOG_VERIFICATION_STEP_FAILED_BECAUSE_OF_ERROR)
                break
            case TestStatus.TestStatusValue.PASSED:
                logger.logPassed(StringConstants.KW_LOG_VERIFICATION_STEP_PASSED)
                break
            default:
                break
        }
    }

    private boolean doValidation(RequestObject request, ResponseObject responseObject, FailureHandling flowControl) {
        WebServiceValidationHelper.executeValidationSteps(request, responseObject, RunConfiguration.getProjectDir());

        List<ValidationStep> validationSteps = request.getValidationSteps();
        if (validationSteps == null || validationSteps.isEmpty()) {
            logger.logPassed(CoreWebserviceMessageConstants.KW_LOG_VALIDATION_SUCCESS)
            return;
        }

        List<String> summaries = new ArrayList<>();
        int numIssues = 0
        validationSteps.forEach({ stepI ->
            if (stepI.results == null || stepI.results.isEmpty()) {
                return;
            }
            List<String> issues = stepI.results.stream()
                    .filter({ resultI ->
                        return resultI.status == ValidationStatus.FAIL || resultI.status == ValidationStatus.ERROR;
                    })
                    .map({ resultI -> return resultI.message })
                    .collect(Collectors.toList());
            String details = issues.size() > 0
                    ? MessageFormat.format("\r\n- {0}", String.join("\r\n- ", issues))
                    : "";
            String status = issues.size() > 0 ? MessageFormat.format("{0} Issue(s)", issues.size()) : "OK";
            String summary = MessageFormat.format("> [{0}]: {1}{2}", stepI.name, status, details);
            summaries.add(summary);
            numIssues += issues.size();
        });

        Set<Error> errors = new HashSet<Error>();
        validationSteps.stream().forEachOrdered({ stepI ->
            errors.addAll(stepI.results);
        });

        if (numIssues == 0) {
            logger.logPassed(CoreWebserviceMessageConstants.KW_LOG_VALIDATION_SUCCESS);
            return true;
        }

        String fullSummary = MessageFormat.format("{0} Issue(s)\r\n{1}\r\n", numIssues, StringUtils.join(summaries, "\r\n\r\n"));
        KeywordMain.stepFailed(fullSummary, flowControl);
    }

    private TestCaseBinding createTestCaseBinding(RequestObject requestObject) {
        Map<String, Object> variables = new HashMap<String, Object>()
        TestCaseBinding testCaseBinding = new TestCaseBinding(requestObject.getName(), variables);
        return testCaseBinding;
    }
}
