package com.kms.katalon.core.webservice.keyword.builtin

import java.nio.charset.StandardCharsets
import java.text.MessageFormat
import java.util.stream.Collectors

import org.apache.commons.io.IOUtils

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.KeywordMain
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.testobject.RequestObject
import com.kms.katalon.core.testobject.ResponseObject
import com.kms.katalon.core.testobject.impl.HttpGraphQLBodyContent
import com.kms.katalon.core.webservice.constants.CoreWebserviceMessageConstants
import com.kms.katalon.core.webservice.helper.WebServiceCommonHelper
import com.kms.katalon.core.webservice.helper.WebServiceValidationHelper
import com.kms.katalon.core.webservice.keyword.internal.WebserviceAbstractKeyword
import com.networknt.schema.Error
import graphql.schema.validation.SchemaValidationError
import graphql.validation.ValidationError
import groovy.transform.CompileStatic

@Action(value = "validateGraphqlRequestAgainstSchema")
public class ValidateGraphQLRequestAgainstSchema extends WebserviceAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
         return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
         Object targetObject = params[0];
         String graphQLSchema = params[1];
         FailureHandling flowControl = getFailureHandling(params, 2);
         if (targetObject instanceof RequestObject) {
             return validateGraphQLBodyWithSchema((RequestObject) targetObject, graphQLSchema, flowControl);
        }
         if (targetObject instanceof String) {
            return validateGraphQLBodyWithSchema((String) targetObject, graphQLSchema, flowControl);
        }
         KeywordMain.stepFailed(CoreWebserviceMessageConstants.KW_LOG_VALIDATION_INVALID_VALIDATION_OBJECT, flowControl);
    }

    @CompileStatic
    public boolean validateGraphQLBodyWithSchema(RequestObject request, String graphQLSchema, FailureHandling flowControl) throws Exception {
         WebServiceCommonHelper.checkRequestObject(request);
         WebServiceCommonHelper.checkRequestObjectBody(request);
         if (request.getBodyContent() instanceof HttpGraphQLBodyContent) {
             HttpGraphQLBodyContent graphQLContent = (HttpGraphQLBodyContent) request.getBodyContent();
             return validateGraphQLBodyWithSchema(graphQLContent.getDisplayText(), graphQLSchema, flowControl);
        }
         KeywordMain.stepFailed(CoreWebserviceMessageConstants.KW_LOG_VALIDATION_INVALID_VALIDATION_OBJECT, flowControl);
    }

    @CompileStatic
    public boolean validateGraphQLBodyWithSchema(String graphQLQuery, String graphQLSchema, FailureHandling flowControl) throws Exception {
        return KeywordMain.runKeyword({
             String schemaContent = WebServiceCommonHelper.smartGetData(graphQLSchema);
             List<ValidationError> errors = WebServiceValidationHelper.validateGraphQLBodyWithSchema(graphQLQuery, schemaContent);

             if (errors == null) {
                 KeywordMain.stepFailed(CoreWebserviceMessageConstants.KW_LOG_VALIDATION_INVALID_GRAPHQL_SCHEMA, flowControl);
                 return false;
            }

             if (errors.isEmpty()) {
                 logger.logPassed(CoreWebserviceMessageConstants.KW_LOG_VALIDATION_VALIDATE_GRAPHQL_SCHEMA_SUCCESS);
                 return true;
            }

             List<String> messages = errors.stream()
                    .map({ resultI -> return resultI.getMessage() })
                     .collect(Collectors.toList());
             String failedMessage = MessageFormat.format("{0} Issue(s):\r\n> {1}", errors.size(), String.join("\r\n> ", messages));

             KeywordMain.stepFailed(failedMessage, flowControl);
             return false;
        }, flowControl, CoreWebserviceMessageConstants.KW_LOG_VALIDATION_VALIDATE_GRAPHQL_SCHEMA_FAILED);
    }
}
