package com.kms.katalon.core.webservice.keyword.builtin

import java.text.MessageFormat
import java.util.stream.Collectors

import org.apache.commons.io.FileUtils
import org.apache.commons.lang3.StringUtils

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepErrorException
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.KeywordMain
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.logging.model.TestStatus
import com.kms.katalon.core.main.TestCaseMain
import com.kms.katalon.core.main.TestResult
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.testcase.TestCaseBinding
import com.kms.katalon.core.testobject.RequestObject
import com.kms.katalon.core.testobject.ResponseObject
import com.kms.katalon.core.webservice.common.HarLogger
import com.kms.katalon.core.webservice.common.ServiceRequestFactory
import com.kms.katalon.core.webservice.constants.CoreWebserviceMessageConstants
import com.kms.katalon.core.webservice.constants.StringConstants
import com.kms.katalon.core.webservice.helper.WebServiceCommonHelper
import com.kms.katalon.core.webservice.helper.WebServiceValidationHelper
import com.kms.katalon.core.webservice.keyword.internal.WebserviceAbstractKeyword
import com.kms.katalon.core.webservice.verification.WSResponseManager
import com.kms.katalon.entity.project.ProjectEntity
import com.networknt.schema.Error

import groovy.transform.CompileStatic

@Action(value = "validateJsonAgainstSchema")
public class ValidateJsonAgainstSchemaKeyword extends WebserviceAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
         Object targetObject = params[0];
         String jsonSchema = params[1];
         FailureHandling flowControl = getFailureHandling(params);
         if (targetObject instanceof ResponseObject) {
             return validateWithJsonSchema((ResponseObject) targetObject, jsonSchema, flowControl);
         }
         if (targetObject instanceof String) {
             return validateWithJsonSchema((String) targetObject, jsonSchema, flowControl);
         }
         KeywordMain.stepFailed(CoreWebserviceMessageConstants.KW_LOG_VALIDATION_INVALID_VALIDATION_OBJECT, flowControl);
    }

    @CompileStatic
    public boolean validateWithJsonSchema(ResponseObject response, String jsonSchema, FailureHandling flowControl) throws Exception {
         WebServiceCommonHelper.checkResponseObject(response);
         WebServiceCommonHelper.checkResponseObjectContent(response);
         return validateWithJsonSchema(response.getResponseText(), jsonSchema, flowControl);
    }

    @CompileStatic
    public boolean validateWithJsonSchema(String jsonObject, String jsonSchema, FailureHandling flowControl) throws Exception {
         return KeywordMain.runKeyword({
             String schemaContent = WebServiceCommonHelper.smartGetData(jsonSchema);
             Set<Error> errors = WebServiceValidationHelper.validateJsonSchema(jsonObject, schemaContent);

             if (errors == null) {
                 KeywordMain.stepFailed(CoreWebserviceMessageConstants.KW_LOG_VALIDATION_INVALID_JSON_SCHEMA, flowControl);
                 return false;
            }

             if (errors.isEmpty()) {
                 logger.logPassed(CoreWebserviceMessageConstants.KW_LOG_VALIDATION_VALIDATE_JSON_SCHEMA_SUCCESS);
                 return true;
            }

             List<String> messages = errors.stream()
                     .map({ resultI -> return MessageFormat.format("Invalid {0}. {1}", resultI.getKeyword(), resultI.getMessage()) })
                     .collect(Collectors.toList());
             String failedMessage = MessageFormat.format("{0} Issue(s):\r\n> {1}", errors.size(), String.join("\r\n> ", messages));

             KeywordMain.stepFailed(failedMessage, flowControl);
             return false;
        }, flowControl, CoreWebserviceMessageConstants.KW_LOG_VALIDATION_VALIDATE_JSON_SCHEMA_FAIL);
    }
}
