package com.kms.katalon.core.webservice.keyword.builtin

import groovy.transform.CompileStatic

import java.text.MessageFormat
import java.util.regex.Pattern

import javax.xml.soap.SOAPMessage

import org.apache.commons.io.FileUtils
import org.apache.commons.io.FilenameUtils
import org.apache.commons.lang.StringUtils

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.KeywordMain
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.logging.KeywordLogger
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.testobject.RequestObject
import com.kms.katalon.core.testobject.ResponseObject
import com.kms.katalon.core.util.FileUtil
import com.kms.katalon.core.util.internal.XMLUtil
import com.kms.katalon.core.webservice.constants.CoreWebserviceMessageConstants
import com.kms.katalon.core.webservice.constants.StringConstants
import com.kms.katalon.core.webservice.helper.WebServiceCommonHelper
import com.kms.katalon.core.webservice.helper.WebServiceValidationHelper
import com.kms.katalon.core.webservice.keyword.internal.WebserviceAbstractKeyword
import com.kms.katalon.core.webservice.util.WebServiceCommonUtil

@Action(value = "validateXmlAgainstSchema")
public class ValidateXmlAgainstSchemaKeyword extends WebserviceAbstractKeyword {
    private final String XML_SCHEMA = "Xml Schema";

    private boolean isSOAP = false;

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
         return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
         Object targetObject = params[0];
         String xmlSchema = params[1];
         FailureHandling flowControl = getFailureHandling(params);
         if (targetObject instanceof ResponseObject) {
             return validateWithXmlSchema((ResponseObject) targetObject, xmlSchema, flowControl);
        }
         if (targetObject instanceof String) {
             return validateXmlOrSOAPWithXmlSchema((String) targetObject, xmlSchema, flowControl);
        }
         KeywordMain.stepFailed(CoreWebserviceMessageConstants.KW_LOG_VALIDATION_INVALID_VALIDATION_OBJECT, flowControl);
    }

    @CompileStatic
    public boolean validateXmlOrSOAPWithXmlSchema(String response, String xmlSchema, FailureHandling flowControl) throws Exception {
         if (XMLUtil.isSOAP(response)) {
             isSOAP = true;
             return validateWithXmlSchema(XMLUtil.extractSOAPBodyAsContent(response), xmlSchema, flowControl)
        }
         return validateWithXmlSchema(response, xmlSchema, flowControl);
    }

    @CompileStatic
    public boolean validateWithXmlSchema(ResponseObject response, String xmlSchema, FailureHandling flowControl) throws Exception {
         WebServiceCommonHelper.checkResponseObject(response);
         WebServiceCommonHelper.checkResponseObjectContent(response);
         isSOAP = response.isSOAPResponse();
         return validateWithXmlSchema(WebServiceCommonHelper.getResponseText(response), xmlSchema, flowControl);
    }

    @CompileStatic
    public boolean validateWithXmlSchema(String xmlObject, String xmlSchema, FailureHandling flowControl) throws StepFailedException {
        return KeywordMain.runKeyword({
             String schemaContent = WebServiceCommonHelper.smartGetData(xmlSchema);
             String error = WebServiceCommonUtil.getXmlValidationErrorString(
                     processValidation(xmlObject, schemaContent));
             error = StringUtils.trim(error);

             if (StringUtils.isNotBlank(error)) {
                 KeywordMain.stepFailed(MessageFormat.format(
                         StringConstants.KW_LOG_VALIDATION_STEP_FAILED_BECAUSE_OF_ERROR, XML_SCHEMA, error), flowControl);
                 return false;
            }

             logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_VALIDATION_STEP_PASSED, XML_SCHEMA));
             return true;
        }, flowControl, StringConstants.KW_LOG_VALIDATION_STEP_FAILED);
    }

    private String processValidation(String xmlObject, String schema) {
         String error = "";
         if (WebServiceValidationHelper.isWSDLSchema(schema)) {
             if (isSOAP) {
                 error = WebServiceValidationHelper.validateWSDLSchema(xmlObject, schema);
             } else {
                 error = CoreWebserviceMessageConstants.KW_LOG_VALIDATION_CANNOT_VALIDATE_XML_AGAINST_WSDL;
            }
         } else {
             error = WebServiceValidationHelper.validateXmlSchema(xmlObject, schema);
        }
         return error;
    }
}
