package com.kms.katalon.core.aut;

import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

public class SeleniumAUT implements ApplicationUnderTest {
    private WebDriver driver;

    protected WebDriver getDriver() {
        return driver;
    }

    public SeleniumAUT(WebDriver driver) {
        this.driver = driver;
    }

    @Override
    public boolean isReady() {
        return getDriver() != null;
    }

    @Override
    public String getPageSource() throws Exception {
        return this.getDriver().getPageSource();
    }

    @Override
    public String takeFullPageScreenshot() throws Exception {
        return ((TakesScreenshot) this.getDriver()).getScreenshotAs(OutputType.BASE64);
    }

    @Override
    public String getAccessibilityTree() throws Exception {
        return null;
    }
}
