package com.kms.katalon.core.aut;

import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

import com.kms.katalon.core.util.HTMLMinifier;

public class WebAUT extends SeleniumAUT {
    public WebAUT(WebDriver driver) {
        super(driver);
    }

    @Override
    public String getPageSource() throws Exception {
        return new HTMLMinifier(super.getPageSource()).minify();
    }

    @Override
    public String getAccessibilityTree() throws Exception {
        var driver = this.getDriver();
        if (!(driver instanceof JavascriptExecutor)) {
            return StringUtils.EMPTY;
        }
        String script = """
                return __captureAccessibilityTree();
                """;
        Object result = ((JavascriptExecutor) driver).executeScript(script);
        return result != null ? result.toString() : StringUtils.EMPTY;
    }
}
