package com.kms.katalon.core.executionpipeline;

import java.util.ArrayList;
import java.util.List;

import com.kms.katalon.core.executionpipeline.ExecutionPhase.ExecutionPhaseContext;

public class SubExecutionPipeline<DataType> {
    public static class SkipPipelineSignal extends Exception {
        private static final long serialVersionUID = 1L;
    }

    private List<ExecutionPhase<DataType>> phases = new ArrayList<>();

    public SubExecutionPipeline(List<ExecutionPhase<DataType>> phases) {
        super();
        this.phases = phases;
    }

    private ExecutionPhaseContext<DataType> createContext(DataType data) {
        return new ExecutionPhaseContext<DataType>(this, data);
    }

    public DataType execute(DataType data) throws Exception {
        return this.execute(this.createContext(data));
    }

    public DataType execute(ExecutionPhaseContext<DataType> context) throws Exception {
        for (var phase : this.phases) {
            try {
                phase.execute(context);
            } catch (SkipPipelineSignal skipSignal) {
                break;
            }
        }
        return context.data;
    }

    public void requestSkip() throws SkipPipelineSignal {
        throw new SkipPipelineSignal();
    }
}
