package com.kms.katalon.core.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.kms.katalon.core.constants.CoreConstants;
import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.logging.model.AbstractLogRecord;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseGroupLogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;

public class LogRecordHelper {
    private LogRecordHelper() {
        // Hide the default constructor
    }

    public static int getLogRecordIndex(ILogRecord logRecord) {
        return getOrder(logRecord);
    }

    public static List<ILogRecord> reduceRawLogRecords(TestSuiteLogRecord testSuiteRecord,
            ILogRecord[] logRecords) {
        List<ILogRecord> testCases = new ArrayList<>();

        for (int i = 0; i < logRecords.length; i++) {
            ILogRecord logRecordI = logRecords[i];
            if (logRecordI instanceof TestCaseGroupLogRecord) {
                testCases.add(logRecordI);
                continue;
            }
            ILogRecord prevTestCase = testCases.size() > 0 ? testCases.get(testCases.size() - 1) : null;
            boolean isRetryResult = getRetryCount(logRecordI) > 0;
            if (prevTestCase != null && isRetryResult) {
                prevTestCase.addChildRecord(logRecordI);
            } else {
                int groupIndex = testCases.size();
                testCases.add(new TestCaseGroupLogRecord(testSuiteRecord, logRecordI, groupIndex));
            }
        }

        return testCases;
    }

    private static int getOrder(ILogRecord logRecord) {
        if (logRecord instanceof TestCaseGroupLogRecord) {
            return ((TestCaseGroupLogRecord) logRecord).getIndexInReport();
        } else if (logRecord instanceof TestCaseLogRecord) {
            return getOrder(logRecord.getParentLogRecord());
        }
        return -1;
    }

    public static int getRetryCount(ILogRecord logRecord) {
        return getIntProperty(logRecord, CoreConstants.TEST_CASE_CURRENT_RETRY_COUNT);
    }    

    public static long getLongProperty(ILogRecord logRecord, String property) {
        String value = getProperty(logRecord, property);
        return StringUtils.isNotBlank(value) ? Long.valueOf(value) : 0;
    }

    public static int getIntProperty(ILogRecord logRecord, String property) {
        String value = getProperty(logRecord, property);
        return StringUtils.isNotBlank(value) ? Integer.valueOf(value) : 0;
    }

    public static String getProperty(ILogRecord logRecord, String property) {
        Map<String, String> props = getProperties(logRecord);
        if (props == null) {
            return null;
        }
        return props.getOrDefault(property, null);
    }

    public static void setProperty(ILogRecord logRecord, String property, Object value) {
        Map<String, String> props = getProperties(logRecord);
        if (props == null) {
            return;
        }
        props.put(property, String.valueOf(value));
    }

    public static Map<String, String> getProperties(ILogRecord logRecord) {
        if (!(logRecord instanceof AbstractLogRecord)) {
            return null;
        }
        return ((AbstractLogRecord) logRecord).getProperties();
    }
}
